/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.frozen;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class FrozenIndicesFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final int numberOfFrozenIndices;

    public FrozenIndicesFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfFrozenIndices = input.readVInt();
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_4_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numberOfFrozenIndices);
    }

    public FrozenIndicesFeatureSetUsage(boolean available, boolean enabled, int numberOfFrozenIndices) {
        super("frozen_indices", available, enabled);
        this.numberOfFrozenIndices = numberOfFrozenIndices;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("indices_count", this.numberOfFrozenIndices);
    }

    public int getNumberOfFrozenIndices() {
        return this.numberOfFrozenIndices;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.numberOfFrozenIndices);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrozenIndicesFeatureSetUsage other = (FrozenIndicesFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.numberOfFrozenIndices, other.numberOfFrozenIndices);
    }
}

