/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.explain;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public class MemoryEstimation
implements ToXContentObject,
Writeable {
    public static final ParseField EXPECTED_MEMORY_WITHOUT_DISK = new ParseField("expected_memory_without_disk", new String[0]);
    public static final ParseField EXPECTED_MEMORY_WITH_DISK = new ParseField("expected_memory_with_disk", new String[0]);
    public static final ConstructingObjectParser<MemoryEstimation, Void> PARSER = new ConstructingObjectParser("memory_estimation", a -> new MemoryEstimation((ByteSizeValue)a[0], (ByteSizeValue)a[1]));
    private final ByteSizeValue expectedMemoryWithoutDisk;
    private final ByteSizeValue expectedMemoryWithDisk;

    public MemoryEstimation(@Nullable ByteSizeValue expectedMemoryWithoutDisk, @Nullable ByteSizeValue expectedMemoryWithDisk) {
        this.expectedMemoryWithoutDisk = expectedMemoryWithoutDisk;
        this.expectedMemoryWithDisk = expectedMemoryWithDisk;
    }

    public MemoryEstimation(StreamInput in) throws IOException {
        this.expectedMemoryWithoutDisk = in.readOptionalWriteable(ByteSizeValue::new);
        this.expectedMemoryWithDisk = in.readOptionalWriteable(ByteSizeValue::new);
    }

    public ByteSizeValue getExpectedMemoryWithoutDisk() {
        return this.expectedMemoryWithoutDisk;
    }

    public ByteSizeValue getExpectedMemoryWithDisk() {
        return this.expectedMemoryWithDisk;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.expectedMemoryWithoutDisk);
        out.writeOptionalWriteable(this.expectedMemoryWithDisk);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.expectedMemoryWithoutDisk != null) {
            builder.field(EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName(), this.expectedMemoryWithoutDisk.getStringRep());
        }
        if (this.expectedMemoryWithDisk != null) {
            builder.field(EXPECTED_MEMORY_WITH_DISK.getPreferredName(), this.expectedMemoryWithDisk.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MemoryEstimation that = (MemoryEstimation)other;
        return Objects.equals(this.expectedMemoryWithoutDisk, that.expectedMemoryWithoutDisk) && Objects.equals(this.expectedMemoryWithDisk, that.expectedMemoryWithDisk);
    }

    public int hashCode() {
        return Objects.hash(this.expectedMemoryWithoutDisk, this.expectedMemoryWithDisk);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), EXPECTED_MEMORY_WITHOUT_DISK.getPreferredName()), EXPECTED_MEMORY_WITHOUT_DISK, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), EXPECTED_MEMORY_WITH_DISK.getPreferredName()), EXPECTED_MEMORY_WITH_DISK, ObjectParser.ValueType.VALUE);
    }
}

