/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.common;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;

public class DataCounts
implements ToXContentObject,
Writeable {
    public static final String TYPE_VALUE = "analytics_data_counts";
    public static final ParseField TRAINING_DOCS_COUNT = new ParseField("training_docs_count", new String[0]);
    public static final ParseField TEST_DOCS_COUNT = new ParseField("test_docs_count", new String[0]);
    public static final ParseField SKIPPED_DOCS_COUNT = new ParseField("skipped_docs_count", new String[0]);
    public static final ConstructingObjectParser<DataCounts, Void> STRICT_PARSER = DataCounts.createParser(false);
    public static final ConstructingObjectParser<DataCounts, Void> LENIENT_PARSER = DataCounts.createParser(true);
    private final String jobId;
    private final long trainingDocsCount;
    private final long testDocsCount;
    private final long skippedDocsCount;

    private static ConstructingObjectParser<DataCounts, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<DataCounts, Void> parser = new ConstructingObjectParser<DataCounts, Void>(TYPE_VALUE, ignoreUnknownFields, a -> new DataCounts((String)a[0], (Long)a[1], (Long)a[2], (Long)a[3]));
        parser.declareString((bucket, s) -> {}, Fields.TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), Fields.JOB_ID);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TRAINING_DOCS_COUNT);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TEST_DOCS_COUNT);
        parser.declareLong(ConstructingObjectParser.constructorArg(), SKIPPED_DOCS_COUNT);
        return parser;
    }

    public DataCounts(String jobId) {
        this(jobId, 0L, 0L, 0L);
    }

    public DataCounts(String jobId, long trainingDocsCount, long testDocsCount, long skippedDocsCount) {
        this.jobId = Objects.requireNonNull(jobId);
        this.trainingDocsCount = trainingDocsCount;
        this.testDocsCount = testDocsCount;
        this.skippedDocsCount = skippedDocsCount;
    }

    public DataCounts(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.trainingDocsCount = in.readVLong();
        this.testDocsCount = in.readVLong();
        this.skippedDocsCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.trainingDocsCount);
        out.writeVLong(this.testDocsCount);
        out.writeVLong(this.skippedDocsCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Fields.TYPE.getPreferredName(), TYPE_VALUE);
            builder.field(Fields.JOB_ID.getPreferredName(), this.jobId);
        }
        builder.field(TRAINING_DOCS_COUNT.getPreferredName(), this.trainingDocsCount);
        builder.field(TEST_DOCS_COUNT.getPreferredName(), this.testDocsCount);
        builder.field(SKIPPED_DOCS_COUNT.getPreferredName(), this.skippedDocsCount);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCounts that = (DataCounts)o;
        return Objects.equals(this.jobId, that.jobId) && this.trainingDocsCount == that.trainingDocsCount && this.testDocsCount == that.testDocsCount && this.skippedDocsCount == that.skippedDocsCount;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.trainingDocsCount, this.testDocsCount, this.skippedDocsCount);
    }

    public static String documentId(String jobId) {
        return "analytics_data_counts_" + jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getTrainingDocsCount() {
        return this.trainingDocsCount;
    }

    public long getTestDocsCount() {
        return this.testDocsCount;
    }

    public long getSkippedDocsCount() {
        return this.skippedDocsCount;
    }
}

