/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.service.ServiceAccountInfo;

public class GetServiceAccountResponse
extends ActionResponse
implements ToXContentObject {
    private final ServiceAccountInfo[] serviceAccountInfos;

    public GetServiceAccountResponse(ServiceAccountInfo[] serviceAccountInfos) {
        this.serviceAccountInfos = Objects.requireNonNull(serviceAccountInfos);
    }

    public GetServiceAccountResponse(StreamInput in) throws IOException {
        super(in);
        this.serviceAccountInfos = in.readArray(ServiceAccountInfo::new, ServiceAccountInfo[]::new);
    }

    public ServiceAccountInfo[] getServiceAccountInfos() {
        return this.serviceAccountInfos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.serviceAccountInfos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ServiceAccountInfo info : this.serviceAccountInfos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "GetServiceAccountResponse{serviceAccountInfos=" + Arrays.toString(this.serviceAccountInfos) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountResponse that = (GetServiceAccountResponse)o;
        return Arrays.equals(this.serviceAccountInfos, that.serviceAccountInfos);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serviceAccountInfos);
    }
}

