/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;

public final class CreateTokenRequest
extends ActionRequest {
    private static final Set<GrantType> SUPPORTED_GRANT_TYPES = Collections.unmodifiableSet(EnumSet.of(GrantType.PASSWORD, GrantType.KERBEROS, GrantType.REFRESH_TOKEN, GrantType.CLIENT_CREDENTIALS));
    private String grantType;
    private String username;
    private SecureString password;
    private SecureString kerberosTicket;
    private String scope;
    private String refreshToken;

    public CreateTokenRequest(StreamInput in) throws IOException {
        super(in);
        this.grantType = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.username = in.readOptionalString();
            this.password = in.readOptionalSecureString();
            this.refreshToken = in.readOptionalString();
            this.kerberosTicket = in.readOptionalSecureString();
        } else {
            this.username = in.readString();
            this.password = in.readSecureString();
        }
        this.scope = in.readOptionalString();
    }

    public CreateTokenRequest() {
    }

    public CreateTokenRequest(String grantType, @Nullable String username, @Nullable SecureString password, @Nullable SecureString kerberosTicket, @Nullable String scope, @Nullable String refreshToken) {
        this.grantType = grantType;
        this.username = username;
        this.password = password;
        this.kerberosTicket = kerberosTicket;
        this.scope = scope;
        this.refreshToken = refreshToken;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        GrantType type = GrantType.fromString(this.grantType);
        if (type != null) {
            switch (type) {
                case PASSWORD: {
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "kerberos_ticket", this.kerberosTicket, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "refresh_token", this.refreshToken, validationException);
                    validationException = CreateTokenRequest.validateRequiredField("username", this.username, validationException);
                    validationException = CreateTokenRequest.validateRequiredField("password", this.password, validationException);
                    break;
                }
                case KERBEROS: {
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "username", this.username, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "password", this.password, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "refresh_token", this.refreshToken, validationException);
                    validationException = CreateTokenRequest.validateRequiredField("kerberos_ticket", this.kerberosTicket, validationException);
                    break;
                }
                case REFRESH_TOKEN: {
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "username", this.username, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "password", this.password, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "kerberos_ticket", this.kerberosTicket, validationException);
                    validationException = CreateTokenRequest.validateRequiredField("refresh_token", this.refreshToken, validationException);
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "username", this.username, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "password", this.password, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "kerberos_ticket", this.kerberosTicket, validationException);
                    validationException = CreateTokenRequest.validateUnsupportedField(type, "refresh_token", this.refreshToken, validationException);
                    break;
                }
                default: {
                    validationException = ValidateActions.addValidationError("grant_type only supports the values: [" + SUPPORTED_GRANT_TYPES.stream().map(GrantType::getValue).collect(Collectors.joining(", ")) + "]", validationException);
                    break;
                }
            }
        } else {
            validationException = ValidateActions.addValidationError("grant_type only supports the values: [" + SUPPORTED_GRANT_TYPES.stream().map(GrantType::getValue).collect(Collectors.joining(", ")) + "]", validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateRequiredField(String field, String fieldValue, ActionRequestValidationException validationException) {
        if (Strings.isNullOrEmpty(fieldValue)) {
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "%s is missing", field), validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateRequiredField(String field, SecureString fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue == null || fieldValue.getChars() == null || fieldValue.length() == 0) {
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "%s is missing", field), validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateUnsupportedField(GrantType grantType, String field, Object fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue != null) {
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "%s is not supported with the %s grant_type", field, grantType.getValue()), validationException);
        }
        return validationException;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public void setPassword(@Nullable SecureString password) {
        this.password = password;
    }

    public void setKerberosTicket(@Nullable SecureString kerberosTicket) {
        this.kerberosTicket = kerberosTicket;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public void setRefreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getGrantType() {
        return this.grantType;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public SecureString getPassword() {
        return this.password;
    }

    @Nullable
    public SecureString getKerberosTicket() {
        return this.kerberosTicket;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_5_0) && GrantType.CLIENT_CREDENTIALS.getValue().equals(this.grantType)) {
            throw new IllegalArgumentException("a request with the client_credentials grant_type cannot be sent to version [" + out.getVersion() + "]");
        }
        if (out.getVersion().before(Version.V_7_3_0) && GrantType.KERBEROS.getValue().equals(this.grantType)) {
            throw new IllegalArgumentException("a request with the _kerberos grant_type cannot be sent to version [" + out.getVersion() + "]");
        }
        out.writeString(this.grantType);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeOptionalString(this.username);
            out.writeOptionalSecureString(this.password);
            out.writeOptionalString(this.refreshToken);
            out.writeOptionalSecureString(this.kerberosTicket);
        } else {
            if ("refresh_token".equals(this.grantType)) {
                throw new IllegalArgumentException("a refresh request cannot be sent to an older version");
            }
            out.writeString(this.username);
            out.writeSecureString(this.password);
        }
        out.writeOptionalString(this.scope);
    }

    public static enum GrantType {
        PASSWORD("password"),
        KERBEROS("_kerberos"),
        REFRESH_TOKEN("refresh_token"),
        AUTHORIZATION_CODE("authorization_code"),
        CLIENT_CREDENTIALS("client_credentials");

        private final String value;

        private GrantType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static GrantType fromString(String grantType) {
            if (grantType != null) {
                for (GrantType type : GrantType.values()) {
                    if (!type.getValue().equals(grantType)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

