/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;

public final class AllExpression
implements RoleMapperExpression {
    public static final String NAME = "all";
    private final List<RoleMapperExpression> elements;

    AllExpression(List<RoleMapperExpression> elements) {
        assert (elements != null);
        this.elements = elements;
    }

    public AllExpression(StreamInput in) throws IOException {
        this(ExpressionParser.readExpressionList(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ExpressionParser.writeExpressionList(this.elements, out);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean match(ExpressionModel model) {
        return this.elements.stream().allMatch(RoleMapperExpression.predicate(model));
    }

    public List<RoleMapperExpression> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllExpression that = (AllExpression)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(ExpressionParser.Fields.ALL.getPreferredName());
        for (RoleMapperExpression e : this.elements) {
            e.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }
}

