/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;
import org.elasticsearch.xpack.core.security.user.User;

public final class DocumentPermissions
implements CacheKey {
    private final SortedSet<BytesReference> queries;
    private final SortedSet<BytesReference> limitedByQueries;
    private List<String> evaluatedQueries;
    private List<String> evaluatedLimitedByQueries;
    private static DocumentPermissions ALLOW_ALL = new DocumentPermissions();

    DocumentPermissions() {
        this.queries = null;
        this.limitedByQueries = null;
    }

    DocumentPermissions(Set<BytesReference> queries) {
        this(queries, null);
    }

    DocumentPermissions(Set<BytesReference> queries, Set<BytesReference> scopedByQueries) {
        if (queries == null && scopedByQueries == null) {
            throw new IllegalArgumentException("one of the queries or scoped queries must be provided");
        }
        this.queries = queries != null ? new TreeSet<BytesReference>(queries) : null;
        this.limitedByQueries = scopedByQueries != null ? new TreeSet<BytesReference>(scopedByQueries) : null;
    }

    public Set<BytesReference> getQueries() {
        return this.queries == null ? null : org.elasticsearch.core.Set.copyOf(this.queries);
    }

    public Set<BytesReference> getLimitedByQueries() {
        return this.limitedByQueries == null ? null : org.elasticsearch.core.Set.copyOf(this.limitedByQueries);
    }

    public boolean hasDocumentLevelPermissions() {
        return this.queries != null || this.limitedByQueries != null;
    }

    public boolean hasStoredScript() throws IOException {
        if (this.queries != null) {
            for (BytesReference q : this.queries) {
                if (!DLSRoleQueryValidator.hasStoredScript(q, NamedXContentRegistry.EMPTY)) continue;
                return true;
            }
        }
        if (this.limitedByQueries != null) {
            for (BytesReference q : this.limitedByQueries) {
                if (!DLSRoleQueryValidator.hasStoredScript(q, NamedXContentRegistry.EMPTY)) continue;
                return true;
            }
        }
        return false;
    }

    public BooleanQuery filter(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, SearchExecutionContext> searchExecutionContextProvider) throws IOException {
        if (this.hasDocumentLevelPermissions()) {
            BooleanQuery.Builder filter;
            this.evaluateQueries(SecurityQueryTemplateEvaluator.wrap(user, scriptService));
            if (this.evaluatedQueries != null && this.evaluatedLimitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                BooleanQuery.Builder scopedFilter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.evaluatedLimitedByQueries, scopedFilter);
                filter.add(scopedFilter.build(), BooleanClause.Occur.FILTER);
                DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.evaluatedQueries, filter);
            } else if (this.evaluatedQueries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.evaluatedQueries, filter);
            } else if (this.evaluatedLimitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.evaluatedLimitedByQueries, filter);
            } else {
                assert (false) : "one of queries and limited-by queries must be non-null";
                return null;
            }
            return filter.build();
        }
        return null;
    }

    private void evaluateQueries(SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) {
        if (this.queries != null && this.evaluatedQueries == null) {
            this.evaluatedQueries = this.queries.stream().map(context::evaluate).collect(Collectors.toList());
        }
        if (this.limitedByQueries != null && this.evaluatedLimitedByQueries == null) {
            this.evaluatedLimitedByQueries = this.limitedByQueries.stream().map(context::evaluate).collect(Collectors.toList());
        }
    }

    private static void buildRoleQuery(ShardId shardId, Function<ShardId, SearchExecutionContext> searchExecutionContextProvider, List<String> queries, BooleanQuery.Builder filter) throws IOException {
        for (String query : queries) {
            SearchExecutionContext context;
            QueryBuilder queryBuilder = DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(query, (context = searchExecutionContextProvider.apply(shardId)).getXContentRegistry());
            if (queryBuilder == null) continue;
            DocumentPermissions.failIfQueryUsesClient(queryBuilder, context);
            Query roleQuery = context.toQuery(queryBuilder).query();
            filter.add(roleQuery, BooleanClause.Occur.SHOULD);
            if (!context.hasNested()) continue;
            NestedHelper nestedHelper = new NestedHelper(context::getObjectMapper, context::isFieldMapped);
            if (nestedHelper.mightMatchNestedDocs(roleQuery)) {
                roleQuery = new BooleanQuery.Builder().add(roleQuery, BooleanClause.Occur.FILTER).add(Queries.newNonNestedFilter(context.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
            BitSetProducer rootDocs = context.bitsetFilter(Queries.newNonNestedFilter(context.indexVersionCreated()));
            ToChildBlockJoinQuery includeNestedDocs = new ToChildBlockJoinQuery(roleQuery, rootDocs);
            filter.add((Query)includeNestedDocs, BooleanClause.Occur.SHOULD);
        }
        filter.setMinimumNumberShouldMatch(1);
    }

    static void failIfQueryUsesClient(QueryBuilder queryBuilder, QueryRewriteContext original) throws IOException {
        QueryRewriteContext copy = new QueryRewriteContext(original.getXContentRegistry(), original.getWriteableRegistry(), null, original::nowInMillis);
        Rewriteable.rewrite(queryBuilder, copy);
        if (copy.hasAsyncActions()) {
            throw new IllegalStateException("role queries are not allowed to execute additional requests");
        }
    }

    public static DocumentPermissions filteredBy(Set<BytesReference> queries) {
        if (queries == null || queries.isEmpty()) {
            throw new IllegalArgumentException("null or empty queries not permitted");
        }
        return new DocumentPermissions(queries);
    }

    public static DocumentPermissions allowAll() {
        return ALLOW_ALL;
    }

    public DocumentPermissions limitDocumentPermissions(DocumentPermissions limitedByDocumentPermissions) {
        assert (this.limitedByQueries == null && limitedByDocumentPermissions.limitedByQueries == null) : "nested scoping for document permissions is not permitted";
        if (this.queries == null && limitedByDocumentPermissions.queries == null) {
            return DocumentPermissions.allowAll();
        }
        return new DocumentPermissions(this.queries, limitedByDocumentPermissions.queries);
    }

    public String toString() {
        return "DocumentPermissions [queries=" + this.queries + ", scopedByQueries=" + this.limitedByQueries + "]";
    }

    @Override
    public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
        assert (!(this.queries == null && this.limitedByQueries == null)) : "one of queries and limited-by queries must be non-null";
        this.evaluateQueries(context);
        if (this.evaluatedQueries != null) {
            out.writeBoolean(true);
            out.writeCollection(this.evaluatedQueries, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.evaluatedLimitedByQueries != null) {
            out.writeBoolean(true);
            out.writeCollection(this.evaluatedLimitedByQueries, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPermissions that = (DocumentPermissions)o;
        return Objects.equals(this.queries, that.queries) && Objects.equals(this.limitedByQueries, that.limitedByQueries);
    }

    public int hashCode() {
        return Objects.hash(this.queries, this.limitedByQueries);
    }
}

