/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;

public final class Validation {
    static final int MIN_NAME_LENGTH = 1;
    static final int MAX_NAME_LENGTH = 1024;
    static final Set<Character> VALID_NAME_CHARS = Collections.unmodifiableSet(Sets.newHashSet(Character.valueOf(' '), Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~')));
    private static final String INVALID_NAME_MESSAGE = "%1s names must be at least 1 and no more than 1024 characters. They can contain alphanumeric characters (a-z, A-Z, 0-9), spaces, punctuation, and printable symbols in the Basic Latin (ASCII) block. Leading or trailing whitespace is not allowed.";
    private static final Pattern VALID_SERVICE_ACCOUNT_TOKEN_NAME = Pattern.compile("^[a-zA-Z0-9-][a-zA-Z0-9_-]{0,255}$");
    public static final String INVALID_SERVICE_ACCOUNT_TOKEN_NAME_MESSAGE = "service account token name must have at least 1 character and at most 256 characters that are alphanumeric (A-Z, a-z, 0-9) or hyphen (-) or underscore (_). It must not begin with an underscore (_).";

    private static boolean isValidUserOrRoleName(String name) {
        if (name.length() < 1 || name.length() > 1024) {
            return false;
        }
        for (char character : name.toCharArray()) {
            if (VALID_NAME_CHARS.contains(Character.valueOf(character))) continue;
            return false;
        }
        return !name.startsWith(" ") && !name.endsWith(" ");
    }

    public static boolean isValidServiceAccountTokenName(String name) {
        return name != null && VALID_SERVICE_ACCOUNT_TOKEN_NAME.matcher(name).matches();
    }

    public static String formatInvalidServiceTokenNameErrorMessage(String name) {
        return "invalid service token name [" + name + "]. " + INVALID_SERVICE_ACCOUNT_TOKEN_NAME_MESSAGE;
    }

    public static class Error {
        private final String message;

        private Error(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    public static final class Roles {
        public static Error validateRoleName(String roleName) {
            return Roles.validateRoleName(roleName, false);
        }

        public static Error validateRoleName(String roleName, boolean allowReserved) {
            if (!Validation.isValidUserOrRoleName(roleName)) {
                return new Error(String.format(Locale.ROOT, Validation.INVALID_NAME_MESSAGE, "Role"));
            }
            if (!allowReserved && ReservedRolesStore.isReserved(roleName)) {
                return new Error("Role [" + roleName + "] is reserved and may not be used.");
            }
            return null;
        }
    }

    public static final class Users {
        private static final int MIN_PASSWD_LENGTH = 6;

        public static Error validateUsername(String username, boolean allowReserved, Settings settings) {
            if (!Validation.isValidUserOrRoleName(username)) {
                return new Error(String.format(Locale.ROOT, Validation.INVALID_NAME_MESSAGE, "User"));
            }
            if (!allowReserved && ClientReservedRealm.isReserved(username, settings)) {
                return new Error("Username [" + username + "] is reserved and may not be used.");
            }
            return null;
        }

        public static Error validatePassword(SecureString password) {
            return password.length() >= 6 ? null : new Error("passwords must be at least [6] characters long");
        }
    }
}

