/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support.xcontent;

import java.io.IOException;
import java.time.ZonedDateTime;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.FilterXContentParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.common.secret.Secret;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;

public class WatcherXContentParser
extends FilterXContentParser {
    public static final String REDACTED_PASSWORD = "::es_redacted::";
    private final ZonedDateTime parseTime;
    @Nullable
    private final CryptoService cryptoService;
    private final boolean allowRedactedPasswords;

    public static Secret secretOrNull(XContentParser parser) throws IOException {
        String text = parser.textOrNull();
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        boolean isEncryptedAlready = text.startsWith("::es_encrypted::");
        if (isEncryptedAlready) {
            return new Secret(chars);
        }
        if (parser instanceof WatcherXContentParser) {
            WatcherXContentParser watcherParser = (WatcherXContentParser)parser;
            if (REDACTED_PASSWORD.equals(text)) {
                if (watcherParser.allowRedactedPasswords) {
                    return null;
                }
                throw new ElasticsearchParseException("found redacted password in field [{}]", parser.currentName());
            }
            if (watcherParser.cryptoService != null) {
                return new Secret(watcherParser.cryptoService.encrypt(chars));
            }
        }
        return new Secret(chars);
    }

    public WatcherXContentParser(XContentParser parser, ZonedDateTime parseTime, @Nullable CryptoService cryptoService, boolean allowRedactedPasswords) {
        super(parser);
        this.parseTime = parseTime;
        this.cryptoService = cryptoService;
        this.allowRedactedPasswords = allowRedactedPasswords;
    }

    public ZonedDateTime getParseDateTime() {
        return this.parseTime;
    }
}

