/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;

public class QlSourceBuilder {
    public static final Version SWITCH_TO_FIELDS_API_VERSION = Version.V_7_10_0;
    private final Set<FieldAndFormat> fetchFields = new LinkedHashSet<FieldAndFormat>();
    private final Map<String, Script> scriptFields = new LinkedHashMap<String, Script>();
    boolean trackScores = false;

    public void trackScores() {
        this.trackScores = true;
    }

    public void addFetchField(String field, String format) {
        this.fetchFields.add(new FieldAndFormat(field, format));
    }

    public void addScriptField(String name, Script script) {
        this.scriptFields.put(name, script);
    }

    public void build(SearchSourceBuilder sourceBuilder) {
        sourceBuilder.trackScores(this.trackScores);
        this.fetchFields.forEach(field -> sourceBuilder.fetchField(new FieldAndFormat(field.field, field.format, null)));
        this.scriptFields.forEach(sourceBuilder::scriptField);
    }
}

