/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class BucketExtractorProcessor
implements Processor {
    public static final String NAME = "a";
    private final BucketExtractor extractor;

    public BucketExtractorProcessor(BucketExtractor extractor) {
        this.extractor = extractor;
    }

    public BucketExtractorProcessor(StreamInput in) throws IOException {
        this.extractor = in.readNamedWriteable(BucketExtractor.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.extractor);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        if (!(input instanceof MultiBucketsAggregation.Bucket)) {
            throw new QlIllegalArgumentException("Expected an agg bucket but received {}", input);
        }
        return this.extractor.extract((MultiBucketsAggregation.Bucket)input);
    }

    public int hashCode() {
        return Objects.hash(this.extractor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BucketExtractorProcessor other = (BucketExtractorProcessor)obj;
        return Objects.equals(this.extractor, other.extractor);
    }

    public String toString() {
        return this.extractor.toString();
    }
}

