/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class UnsupportedEsField
extends EsField {
    private final String originalType;
    private final String inherited;

    public UnsupportedEsField(String name, String originalType) {
        this(name, originalType, null, new TreeMap<String, EsField>());
    }

    public UnsupportedEsField(String name, String originalType, String inherited, Map<String, EsField> properties) {
        super(name, DataTypes.UNSUPPORTED, properties, false);
        this.originalType = originalType;
        this.inherited = inherited;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean hasInherited() {
        return this.inherited != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnsupportedEsField that = (UnsupportedEsField)o;
        return Objects.equals(this.originalType, that.originalType) && Objects.equals(this.inherited, that.inherited);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originalType, this.inherited);
    }
}

