/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.RequestInfo;

public class SqlClearCursorRequest
extends AbstractSqlRequest {
    private final String cursor;

    public SqlClearCursorRequest(String cursor, RequestInfo requestInfo) {
        super(requestInfo);
        this.cursor = cursor;
    }

    public String getCursor() {
        return this.cursor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlClearCursorRequest that = (SqlClearCursorRequest)o;
        return Objects.equals(this.cursor, that.cursor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cursor", this.cursor);
        builder.field("mode", this.mode().toString());
        if (this.clientId() != null) {
            builder.field("client_id", this.clientId());
        }
        if (this.version() != null) {
            builder.field("version", this.version().toString());
        }
        return builder;
    }
}

