/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlRequest {
    @Nullable
    private final String cursor;
    private final String query;
    private final ZoneId zoneId;
    private final int fetchSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    @Nullable
    private final ToXContent filter;
    private final Boolean columnar;
    private final List<SqlTypedParamValue> params;
    private final boolean fieldMultiValueLeniency;
    private final boolean indexIncludeFrozen;
    private final Boolean binaryCommunication;
    @Nullable
    private final Map<String, Object> runtimeMappings;
    private final TimeValue waitForCompletionTimeout;
    private final boolean keepOnCompletion;
    private final TimeValue keepAlive;

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, ToXContent filter, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen, Boolean binaryCommunication, Map<String, Object> runtimeMappings, TimeValue waitForCompletionTimeout, boolean keepOnCompletion, TimeValue keepAlive) {
        super(requestInfo);
        this.query = query;
        this.params = params;
        this.zoneId = zoneId;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.columnar = columnar;
        this.cursor = cursor;
        this.fieldMultiValueLeniency = fieldMultiValueLeniency;
        this.indexIncludeFrozen = indexIncludeFrozen;
        this.binaryCommunication = binaryCommunication;
        this.runtimeMappings = runtimeMappings;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        this.keepOnCompletion = keepOnCompletion;
        this.keepAlive = keepAlive;
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, ToXContent filter, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen, Boolean binaryCommunication, Map<String, Object> runtimeMappings) {
        this(query, params, zoneId, fetchSize, requestTimeout, pageTimeout, filter, columnar, cursor, requestInfo, fieldMultiValueLeniency, indexIncludeFrozen, binaryCommunication, runtimeMappings, Protocol.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT, Protocol.DEFAULT_KEEP_ON_COMPLETION, Protocol.DEFAULT_KEEP_ALIVE);
    }

    public SqlQueryRequest(String cursor, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo, boolean binaryCommunication) {
        this("", Collections.emptyList(), Protocol.TIME_ZONE, 1000, requestTimeout, pageTimeout, null, false, cursor, requestInfo, false, false, binaryCommunication, Collections.emptyMap());
    }

    public String cursor() {
        return this.cursor;
    }

    public String query() {
        return this.query;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public ToXContent filter() {
        return this.filter;
    }

    public Boolean columnar() {
        return this.columnar;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public boolean indexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    public Boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlQueryRequest that = (SqlQueryRequest)o;
        return this.fetchSize == that.fetchSize && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.filter, that.filter) && Objects.equals(this.columnar, that.columnar) && Objects.equals(this.cursor, that.cursor) && this.fieldMultiValueLeniency == that.fieldMultiValueLeniency && this.indexIncludeFrozen == that.indexIncludeFrozen && Objects.equals(this.binaryCommunication, that.binaryCommunication) && Objects.equals(this.runtimeMappings, that.runtimeMappings) && Objects.equals(this.waitForCompletionTimeout, that.waitForCompletionTimeout) && this.keepOnCompletion == that.keepOnCompletion && Objects.equals(this.keepAlive, that.keepAlive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.zoneId, this.fetchSize, this.requestTimeout, this.pageTimeout, this.filter, this.columnar, this.cursor, this.fieldMultiValueLeniency, this.indexIncludeFrozen, this.binaryCommunication, this.runtimeMappings, this.waitForCompletionTimeout, this.keepOnCompletion, this.keepAlive);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.query != null) {
            builder.field("query", this.query);
        }
        builder.field("mode", this.mode().toString());
        if (this.clientId() != null) {
            builder.field("client_id", this.clientId());
        }
        if (this.version() != null) {
            builder.field("version", this.version().toString());
        }
        if (this.params != null && !this.params.isEmpty()) {
            builder.startArray("params");
            for (SqlTypedParamValue val : this.params) {
                val.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.zoneId != null) {
            builder.field("time_zone", this.zoneId.getId());
        }
        if (this.fetchSize != 1000) {
            builder.field("fetch_size", this.fetchSize);
        }
        if (this.requestTimeout != Protocol.REQUEST_TIMEOUT) {
            builder.field("request_timeout", this.requestTimeout.getStringRep());
        }
        if (this.pageTimeout != Protocol.PAGE_TIMEOUT) {
            builder.field("page_timeout", this.pageTimeout.getStringRep());
        }
        if (this.filter != null) {
            builder.field("filter");
            this.filter.toXContent(builder, params);
        }
        if (this.columnar != null) {
            builder.field("columnar", this.columnar);
        }
        if (this.fieldMultiValueLeniency) {
            builder.field("field_multi_value_leniency", this.fieldMultiValueLeniency);
        }
        if (this.indexIncludeFrozen) {
            builder.field("index_include_frozen", this.indexIncludeFrozen);
        }
        if (this.binaryCommunication != null) {
            builder.field("binary_format", this.binaryCommunication);
        }
        if (this.cursor != null) {
            builder.field("cursor", this.cursor);
        }
        if (!this.runtimeMappings.isEmpty()) {
            builder.field("runtime_mappings", this.runtimeMappings);
        }
        if (this.waitForCompletionTimeout != null) {
            builder.field("wait_for_completion_timeout", this.waitForCompletionTimeout.getStringRep());
        }
        if (this.keepOnCompletion) {
            builder.field("keep_on_completion", this.keepOnCompletion);
        }
        if (this.keepAlive != null) {
            builder.field("keep_alive", this.keepAlive.getStringRep());
        }
        return builder;
    }
}

