/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;

public class Realms
implements Iterable<Realm> {
    private static final Logger logger = LogManager.getLogger(Realms.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    private final Settings settings;
    private final Environment env;
    private final Map<String, Realm.Factory> factories;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final ReservedRealm reservedRealm;
    private final List<Realm> allConfiguredRealms;
    private final List<Realm> nativeRealmsOnly;
    private volatile List<Realm> activeRealms;

    public Realms(Settings settings, Environment env, Map<String, Realm.Factory> factories, XPackLicenseState licenseState, ThreadContext threadContext, ReservedRealm reservedRealm) throws Exception {
        this.settings = settings;
        this.env = env;
        this.factories = factories;
        this.licenseState = licenseState;
        this.threadContext = threadContext;
        this.reservedRealm = reservedRealm;
        assert (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) : "security must be enabled";
        assert (factories.get("reserved") == null);
        this.allConfiguredRealms = this.initRealms();
        this.allConfiguredRealms.forEach(r -> r.initialize(this.allConfiguredRealms, licenseState));
        assert (this.allConfiguredRealms.get(0) == reservedRealm) : "the first realm must be reserved realm";
        this.nativeRealmsOnly = Collections.unmodifiableList(this.buildFallbackNativeRealms());
        assert (this.nativeRealmsOnly.get(0) == reservedRealm) : "the first realm must be reserved realm";
        this.recomputeActiveRealms();
        licenseState.addListener(this::recomputeActiveRealms);
    }

    private List<Realm> buildFallbackNativeRealms() throws Exception {
        ArrayList<Realm> nativeRealms = new ArrayList<Realm>();
        for (Realm realm : this.allConfiguredRealms) {
            if (!InternalRealms.isBuiltinRealm(realm.type())) continue;
            nativeRealms.add(realm);
        }
        nativeRealms.add(0, this.reservedRealm);
        if (nativeRealms.size() == 1) {
            this.addNativeRealms(nativeRealms);
            nativeRealms.forEach(r -> r.initialize((Iterable)nativeRealms, this.licenseState));
        }
        return nativeRealms;
    }

    protected void recomputeActiveRealms() {
        XPackLicenseState licenseStateSnapshot = this.licenseState.copyCurrentLicenseState();
        if (!licenseStateSnapshot.isSecurityEnabled()) {
            this.activeRealms = Collections.emptyList();
            return;
        }
        List<Realm> licensedRealms = this.calculateLicensedRealms(licenseStateSnapshot);
        logger.info("license mode is [{}], currently licensed security realms are [{}]", (Object)licenseStateSnapshot.getOperationMode().description(), (Object)Strings.collectionToCommaDelimitedString(licensedRealms));
        if (this.activeRealms != null) {
            this.activeRealms.stream().filter(r -> !licensedRealms.contains(r)).forEach(realm -> {
                if (InternalRealms.isStandardRealm(realm.type())) {
                    Security.STANDARD_REALMS_FEATURE.stopTracking(licenseStateSnapshot, realm.name());
                } else {
                    Security.ALL_REALMS_FEATURE.stopTracking(licenseStateSnapshot, realm.name());
                }
            });
        }
        this.activeRealms = licensedRealms;
    }

    @Override
    public Iterator<Realm> iterator() {
        return this.getActiveRealms().iterator();
    }

    public List<Realm> getUnlicensedRealms() {
        List<Realm> activeSnapshot = this.activeRealms;
        if (activeSnapshot.equals(this.allConfiguredRealms)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.allConfiguredRealms.stream().filter(r -> !activeSnapshot.contains(r)).collect(Collectors.toList()));
    }

    public Stream<Realm> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public List<Realm> getActiveRealms() {
        assert (this.activeRealms != null) : "Active realms not configured";
        return this.activeRealms;
    }

    protected List<Realm> calculateLicensedRealms(XPackLicenseState licenseStateSnapshot) {
        List<Realm> licensed = this.allConfiguredRealms.stream().filter(r -> Realms.checkLicense(r, licenseStateSnapshot)).collect(Collectors.toList());
        if (this.hasUserRealm(licensed)) {
            return Collections.unmodifiableList(licensed);
        }
        return this.nativeRealmsOnly;
    }

    private boolean hasUserRealm(List<Realm> licensedRealms) {
        if (licensedRealms.isEmpty()) {
            return false;
        }
        return licensedRealms.size() != 1 || licensedRealms.get(0) != this.reservedRealm;
    }

    private static boolean checkLicense(Realm realm, XPackLicenseState licenseState) {
        if (Realms.isBasicLicensedRealm(realm.type())) {
            return true;
        }
        if (InternalRealms.isStandardRealm(realm.type())) {
            return Security.STANDARD_REALMS_FEATURE.checkAndStartTracking(licenseState, realm.name());
        }
        return Security.ALL_REALMS_FEATURE.checkAndStartTracking(licenseState, realm.name());
    }

    public static boolean isRealmTypeAvailable(XPackLicenseState licenseState, String type) {
        if (Security.ALL_REALMS_FEATURE.checkWithoutTracking(licenseState)) {
            return true;
        }
        if (Security.STANDARD_REALMS_FEATURE.checkWithoutTracking(licenseState)) {
            return InternalRealms.isStandardRealm(type) || "reserved".equals(type);
        }
        return Realms.isBasicLicensedRealm(type);
    }

    private static boolean isBasicLicensedRealm(String type) {
        return "reserved".equals(type) || InternalRealms.isBuiltinRealm(type);
    }

    public Realm realm(String name) {
        for (Realm realm : this.activeRealms) {
            if (!name.equals(realm.name())) continue;
            return realm;
        }
        return null;
    }

    public Realm.Factory realmFactory(String type) {
        return this.factories.get(type);
    }

    protected List<Realm> initRealms() throws Exception {
        Map realmsSettings = RealmSettings.getRealmSettings((Settings)this.settings);
        HashSet<String> internalTypes = new HashSet<String>();
        ArrayList<Realm> realms = new ArrayList<Realm>();
        ArrayList<String> kerberosRealmNames = new ArrayList<String>();
        HashMap<String, Set> nameToRealmIdentifier = new HashMap<String, Set>();
        TreeSet<String> missingOrderRealmSettingKeys = new TreeSet<String>();
        HashMap<String, Set<String>> orderToRealmOrderSettingKeys = new HashMap<String, Set<String>>();
        ArrayList<RealmConfig.RealmIdentifier> reservedPrefixedRealmIdentifiers = new ArrayList<RealmConfig.RealmIdentifier>();
        HashSet<String> unconfiguredBasicRealms = new HashSet<String>(org.elasticsearch.core.Set.of((Object)"file", (Object)"native"));
        for (Map.Entry entry2 : realmsSettings.entrySet()) {
            Realm.Factory factory;
            RealmConfig.RealmIdentifier identifier = (RealmConfig.RealmIdentifier)entry2.getKey();
            if (!((Settings)entry2.getValue()).hasValue("order")) {
                if (((Settings)entry2.getValue()).getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
                    missingOrderRealmSettingKeys.add(RealmSettings.getFullSettingKey((RealmConfig.RealmIdentifier)identifier, (Function)RealmSettings.ORDER_SETTING));
                }
            } else {
                orderToRealmOrderSettingKeys.computeIfAbsent(((Settings)entry2.getValue()).get("order"), k -> new TreeSet()).add(RealmSettings.getFullSettingKey((RealmConfig.RealmIdentifier)identifier, (Function)RealmSettings.ORDER_SETTING));
            }
            if ((factory = this.factories.get(identifier.getType())) == null) {
                throw new IllegalArgumentException("unknown realm type [" + identifier.getType() + "] for realm [" + identifier + "]");
            }
            if (identifier.getName().startsWith("_")) {
                reservedPrefixedRealmIdentifiers.add(identifier);
            }
            RealmConfig config = new RealmConfig(identifier, this.settings, this.env, this.threadContext);
            unconfiguredBasicRealms.remove(identifier.getType());
            if (!config.enabled()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("realm [{}] is disabled", (Object)identifier);
                continue;
            }
            if ("file".equals(identifier.getType()) || "native".equals(identifier.getType())) {
                if (internalTypes.contains(identifier.getType())) {
                    throw new IllegalArgumentException("multiple [" + identifier.getType() + "] realms are configured. [" + identifier.getType() + "] is an internal realm and therefore there can only be one such realm configured");
                }
                internalTypes.add(identifier.getType());
            }
            if ("kerberos".equals(identifier.getType())) {
                kerberosRealmNames.add(identifier.getName());
                if (kerberosRealmNames.size() > 1) {
                    throw new IllegalArgumentException("multiple realms " + ((Object)kerberosRealmNames).toString() + " configured of type [" + identifier.getType() + "], [" + identifier.getType() + "] can only have one such realm configured");
                }
            }
            Realm realm = factory.create(config);
            nameToRealmIdentifier.computeIfAbsent(realm.name(), k -> new HashSet()).add(RealmSettings.realmSettingPrefix((String)realm.type()) + realm.name());
            realms.add(realm);
        }
        this.logDeprecationForImplicitlyDisabledBasicRealms(realms, unconfiguredBasicRealms);
        if (!realms.isEmpty()) {
            Collections.sort(realms);
        } else {
            this.addNativeRealms(realms);
        }
        realms.add(0, this.reservedRealm);
        String duplicateRealms = nameToRealmIdentifier.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("; "));
        if (Strings.hasText((String)duplicateRealms)) {
            throw new IllegalArgumentException("Found multiple realms configured with the same name: " + duplicateRealms + "");
        }
        this.logDeprecationIfFound(missingOrderRealmSettingKeys, orderToRealmOrderSettingKeys);
        this.logDeprecationForReservedPrefixedRealmNames(reservedPrefixedRealmIdentifiers);
        return Collections.unmodifiableList(realms);
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        XPackLicenseState licenseStateSnapshot = this.licenseState.copyCurrentLicenseState();
        HashMap realmMap = new HashMap();
        AtomicBoolean failed = new AtomicBoolean(false);
        List realmList = this.getActiveRealms().stream().filter(r -> !"reserved".equals(r.type())).collect(Collectors.toList());
        Set realmTypes = realmList.stream().map(Realm::type).collect(Collectors.toSet());
        CountDown countDown = new CountDown(realmList.size());
        Runnable doCountDown = () -> {
            if ((realmList.isEmpty() || countDown.countDown()) && !failed.get()) {
                for (String type : this.factories.keySet()) {
                    assert (!"reserved".equals(type));
                    realmMap.compute(type, (key, value) -> {
                        if (value == null) {
                            return MapBuilder.newMapBuilder().put((Object)"enabled", (Object)false).put((Object)"available", (Object)Realms.isRealmTypeAvailable(licenseStateSnapshot, type)).map();
                        }
                        assert (value instanceof Map);
                        Map realmTypeUsage = (Map)value;
                        realmTypeUsage.put("enabled", true);
                        realmTypeUsage.put("available", true);
                        return value;
                    });
                }
                listener.onResponse((Object)realmMap);
            }
        };
        if (realmList.isEmpty()) {
            doCountDown.run();
        } else {
            for (Realm realm : realmList) {
                realm.usageStats(ActionListener.wrap(stats -> {
                    if (!failed.get()) {
                        Map map = realmMap;
                        synchronized (map) {
                            realmMap.compute(realm.type(), (key, value) -> {
                                if (value == null) {
                                    Map<String, Object> realmTypeUsage = Realms.convertToMapOfLists(stats);
                                    return realmTypeUsage;
                                }
                                assert (value instanceof Map);
                                Realms.combineMaps((Map)value, stats);
                                return value;
                            });
                        }
                        doCountDown.run();
                    }
                }, e -> {
                    if (failed.compareAndSet(false, true)) {
                        listener.onFailure(e);
                    }
                }));
            }
        }
    }

    private void addNativeRealms(List<Realm> realms) throws Exception {
        Realm.Factory indexRealmFactory;
        Realm.Factory fileRealm = this.factories.get("file");
        if (fileRealm != null) {
            RealmConfig.RealmIdentifier realmIdentifier = new RealmConfig.RealmIdentifier("file", "default_file");
            realms.add(fileRealm.create(new RealmConfig(realmIdentifier, this.settings, this.env, this.threadContext)));
        }
        if ((indexRealmFactory = this.factories.get("native")) != null) {
            RealmConfig.RealmIdentifier realmIdentifier = new RealmConfig.RealmIdentifier("native", "default_native");
            realms.add(indexRealmFactory.create(new RealmConfig(realmIdentifier, this.settings, this.env, this.threadContext)));
        }
    }

    private static void combineMaps(Map<String, Object> mapA, Map<String, Object> mapB) {
        for (Map.Entry<String, Object> entry : mapB.entrySet()) {
            mapA.compute(entry.getKey(), (key, value) -> {
                if (value == null) {
                    return new ArrayList(Collections.singletonList(entry.getValue()));
                }
                assert (value instanceof List);
                ((List)value).add(entry.getValue());
                return value;
            });
        }
    }

    private static Map<String, Object> convertToMapOfLists(Map<String, Object> map) {
        HashMap<String, Object> converted = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            converted.put(entry.getKey(), new ArrayList<Object>(Collections.singletonList(entry.getValue())));
        }
        return converted;
    }

    private void logDeprecationIfFound(Set<String> missingOrderRealmSettingKeys, Map<String, Set<String>> orderToRealmOrderSettingKeys) {
        List duplicatedRealmOrderSettingKeys;
        if (missingOrderRealmSettingKeys.size() > 0) {
            deprecationLogger.deprecate(DeprecationCategory.SECURITY, "unordered_realm_config", "Found realms without order config: [{}]. In next major release, node will fail to start with missing realm order.", new Object[]{String.join((CharSequence)"; ", missingOrderRealmSettingKeys)});
        }
        if (!(duplicatedRealmOrderSettingKeys = orderToRealmOrderSettingKeys.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).map(e -> (String)e.getKey() + ": " + String.join((CharSequence)",", (Iterable)e.getValue())).sorted().collect(Collectors.toList())).isEmpty()) {
            deprecationLogger.deprecate(DeprecationCategory.SECURITY, "duplicate_realm_order", "Found multiple realms configured with the same order: [{}]. In next major release, node will fail to start with duplicated realm order.", new Object[]{String.join((CharSequence)"; ", duplicatedRealmOrderSettingKeys)});
        }
    }

    private void logDeprecationForImplicitlyDisabledBasicRealms(List<Realm> realms, Set<String> unconfiguredBasicRealms) {
        if (realms.isEmpty()) {
            List explicitlyDisabledBasicRealms = Sets.difference((Set)org.elasticsearch.core.Set.of((Object)"file", (Object)"native"), unconfiguredBasicRealms).stream().sorted().collect(Collectors.toList());
            if (explicitlyDisabledBasicRealms.isEmpty()) {
                return;
            }
            deprecationLogger.deprecate(DeprecationCategory.SECURITY, "implicitly_disabled_basic_realms", "Found explicitly disabled basic {}: [{}]. But {} will be enabled because no other realms are configured or enabled. In next major release, explicitly disabled basic realms will remain disabled.", new Object[]{explicitlyDisabledBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(explicitlyDisabledBasicRealms, (String)","), explicitlyDisabledBasicRealms.size() == 1 ? "it" : "they"});
        } else {
            if (unconfiguredBasicRealms.isEmpty()) {
                return;
            }
            deprecationLogger.deprecate(DeprecationCategory.SECURITY, "implicitly_disabled_basic_realms", "Found implicitly disabled basic {}: [{}]. {} disabled because there are other explicitly configured realms. In next major release, basic realms will always be enabled unless explicitly disabled.", new Object[]{unconfiguredBasicRealms.size() == 1 ? "realm" : "realms", Strings.collectionToDelimitedString(unconfiguredBasicRealms, (String)","), unconfiguredBasicRealms.size() == 1 ? "It is" : "They are"});
        }
    }

    private void logDeprecationForReservedPrefixedRealmNames(List<RealmConfig.RealmIdentifier> realmIdentifiers) {
        if (!realmIdentifiers.isEmpty()) {
            deprecationLogger.deprecate(DeprecationCategory.SECURITY, "realm_name_with_reserved_prefix", "Found realm " + (realmIdentifiers.size() == 1 ? "name" : "names") + " with reserved prefix [{}]: [{}]. In a future major release, node will fail to start if any realm names start with reserved prefix.", new Object[]{"_", realmIdentifiers.stream().map(rid -> "xpack.security.authc.realms." + rid.getType() + "." + rid.getName()).sorted().collect(Collectors.joining("; "))});
        }
    }
}

