/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.crypto.tool;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;

public class SystemKeyTool
extends EnvironmentAwareCommand {
    static final String KEY_ALGO = "HmacSHA512";
    static final int KEY_SIZE = 1024;
    private final OptionSpec<String> arguments;
    public static final Set<PosixFilePermission> PERMISSION_OWNER_READ_WRITE = Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});

    SystemKeyTool() {
        super("system key tool");
        this.arguments = this.parser.nonOptions("key path");
    }

    public static void main(String[] args) throws Exception {
        SystemKeyTool tool = new SystemKeyTool();
        int status = SystemKeyTool.main(tool, args, Terminal.DEFAULT);
        if (status != 0) {
            SystemKeyTool.exit((int)status);
        }
    }

    static int main(SystemKeyTool tool, String[] args, Terminal terminal) throws Exception {
        return tool.main(args, terminal);
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path keyPath;
        if (options.hasArgument(this.arguments)) {
            List args = this.arguments.values(options);
            if (args.size() > 1) {
                throw new UserException(64, "No more than one key path can be supplied");
            }
            keyPath = SystemKeyTool.parsePath((String)args.get(0));
        } else {
            keyPath = XPackPlugin.resolveConfigFile((Environment)env, (String)"system_key");
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "generating...");
        byte[] key = SystemKeyTool.generateKey();
        terminal.println(String.format(Locale.ROOT, "Storing generated key in [%s]...", keyPath.toAbsolutePath()));
        Files.write(keyPath, key, StandardOpenOption.CREATE_NEW);
        PosixFileAttributeView view = Files.getFileAttributeView(keyPath, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null) {
            view.setPermissions(PERMISSION_OWNER_READ_WRITE);
            terminal.println("Ensure the generated key can be read by the user that Elasticsearch runs as, permissions are set to owner read/write only");
        }
    }

    static byte[] generateKey() {
        return SystemKeyTool.generateSecretKey(1024).getEncoded();
    }

    static SecretKey generateSecretKey(int keyLength) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(KEY_ALGO);
            generator.init(keyLength);
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ElasticsearchException("failed to generate key", (Throwable)e, new Object[0]);
        }
    }

    @SuppressForbidden(reason="Parsing command line path")
    private static Path parsePath(String path) {
        return PathUtils.get((String)path, (String[])new String[0]);
    }
}

