/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ConstantInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.ql.querydsl.query.MatchAll;
import org.elasticsearch.xpack.ql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.ScorePipe;
import org.elasticsearch.xpack.sql.querydsl.agg.Aggs;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.AggregateSort;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class QueryContainer {
    private final Aggs aggs;
    private final Query query;
    private final List<Tuple<FieldExtraction, String>> fields;
    private final AttributeMap<Expression> aliases;
    private final Map<String, GroupByKey> pseudoFunctions;
    private AttributeMap<Pipe> scalarFunctions;
    private final Map<String, Sort> sort;
    private final int limit;
    private final boolean trackHits;
    private final boolean includeFrozen;
    private final int minPageSize;
    private Boolean aggsOnly;
    private Boolean customSort;
    private Map<Attribute, FieldAttribute> fieldAlias;

    public QueryContainer() {
        this(null, null, null, null, null, null, null, -1, false, false, -1);
    }

    public QueryContainer(Query query, Aggs aggs, List<Tuple<FieldExtraction, String>> fields, AttributeMap<Expression> aliases, Map<String, GroupByKey> pseudoFunctions, AttributeMap<Pipe> scalarFunctions, Map<String, Sort> sort, int limit, boolean trackHits, boolean includeFrozen, int minPageSize) {
        this.query = query;
        this.aggs = aggs == null ? Aggs.EMPTY : aggs;
        this.fields = fields == null || fields.isEmpty() ? Collections.emptyList() : fields;
        this.aliases = aliases == null || aliases.isEmpty() ? AttributeMap.emptyAttributeMap() : aliases;
        this.pseudoFunctions = pseudoFunctions == null || pseudoFunctions.isEmpty() ? Collections.emptyMap() : pseudoFunctions;
        this.scalarFunctions = scalarFunctions == null || scalarFunctions.isEmpty() ? AttributeMap.emptyAttributeMap() : scalarFunctions;
        this.sort = sort == null || sort.isEmpty() ? Collections.emptyMap() : sort;
        this.limit = limit;
        this.trackHits = trackHits;
        this.includeFrozen = includeFrozen;
        this.minPageSize = minPageSize;
    }

    public List<Tuple<Integer, Comparator>> sortingColumns() {
        if (this.customSort == Boolean.FALSE) {
            return Collections.emptyList();
        }
        for (Sort s : this.sort.values()) {
            if (!(s instanceof AggregateSort)) continue;
            this.customSort = Boolean.TRUE;
            break;
        }
        if (this.customSort == null) {
            this.customSort = Boolean.FALSE;
            return Collections.emptyList();
        }
        ArrayList<Tuple<Integer, Comparator>> sortingColumns = new ArrayList<Tuple<Integer, Comparator>>(this.sort.size());
        for (Map.Entry<String, Sort> entry : this.sort.entrySet()) {
            String expressionId = entry.getKey();
            Sort s = entry.getValue();
            int atIndex = -1;
            for (int i = 0; i < this.fields.size(); ++i) {
                Tuple<FieldExtraction, String> field = this.fields.get(i);
                if (!((String)field.v2()).equals(expressionId)) continue;
                atIndex = i;
                break;
            }
            if (atIndex == -1) {
                throw new SqlIllegalArgumentException("Cannot find backing column for ordering aggregation [{}]", s);
            }
            Comparator comp = null;
            if (s instanceof AggregateSort) {
                comp = s.direction() == Sort.Direction.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder();
                comp = s.missing() == Sort.Missing.FIRST ? Comparator.nullsFirst(comp) : Comparator.nullsLast(comp);
            }
            sortingColumns.add((Tuple<Integer, Comparator>)new Tuple((Object)atIndex, comp));
        }
        return sortingColumns;
    }

    public BitSet columnMask(List<Attribute> columns) {
        BitSet mask = new BitSet(this.fields.size());
        if (columns.size() > 0) {
            this.aliasName(columns.get(0));
        }
        for (Attribute column : columns) {
            Expression expression = (Expression)this.aliases.resolve((Object)column, (Object)column);
            String id = Expressions.id((Expression)expression);
            int index = -1;
            for (int i = 0; i < this.fields.size(); ++i) {
                Tuple<FieldExtraction, String> tuple = this.fields.get(i);
                if (mask.get(i) || !((String)tuple.v2()).equals(id)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                mask.set(index);
                continue;
            }
            throw new SqlIllegalArgumentException("Cannot resolve field extractor index for column [{}]", column);
        }
        return mask;
    }

    public Query query() {
        return this.query;
    }

    public Aggs aggs() {
        return this.aggs;
    }

    public List<Tuple<FieldExtraction, String>> fields() {
        return this.fields;
    }

    public AttributeMap<Expression> aliases() {
        return this.aliases;
    }

    public Map<String, GroupByKey> pseudoFunctions() {
        return this.pseudoFunctions;
    }

    public Map<String, Sort> sort() {
        return this.sort;
    }

    public int limit() {
        return this.limit;
    }

    public boolean isAggsOnly() {
        if (this.aggsOnly == null) {
            this.aggsOnly = this.fields.stream().anyMatch(t -> ((FieldExtraction)t.v1()).supportedByAggsOnlyQuery());
        }
        return this.aggsOnly;
    }

    public boolean hasColumns() {
        return this.fields.size() > 0;
    }

    public boolean shouldTrackHits() {
        return this.trackHits;
    }

    public boolean shouldIncludeFrozen() {
        return this.includeFrozen;
    }

    public int minPageSize() {
        return this.minPageSize;
    }

    public QueryContainer with(Query q) {
        return new QueryContainer(q, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer withAliases(AttributeMap<Expression> a) {
        return new QueryContainer(this.query, this.aggs, this.fields, a, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer withPseudoFunctions(Map<String, GroupByKey> p) {
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, p, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer with(Aggs a) {
        return new QueryContainer(this.query, a, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer withLimit(int l) {
        return l == this.limit ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, l, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer withTrackHits() {
        return this.trackHits ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, true, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer withFrozen() {
        return this.includeFrozen ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, true, this.minPageSize);
    }

    public QueryContainer withScalarProcessors(AttributeMap<Pipe> procs) {
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, procs, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public QueryContainer prependSort(String expressionId, Sort sortable) {
        LinkedHashMap<String, Sort> newSort = new LinkedHashMap<String, Sort>(this.sort.size() + 1);
        newSort.put(expressionId, sortable);
        for (Map.Entry<String, Sort> entry : this.sort.entrySet()) {
            newSort.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, newSort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    private String aliasName(Attribute attr) {
        FieldAttribute fa;
        if (this.fieldAlias == null) {
            this.fieldAlias = new LinkedHashMap<Attribute, FieldAttribute>();
            for (Map.Entry entry : this.aliases.entrySet()) {
                if (!(entry.getValue() instanceof FieldAttribute)) continue;
                this.fieldAlias.put((Attribute)entry.getKey(), (FieldAttribute)entry.getValue());
            }
        }
        return (fa = this.fieldAlias.get(attr)) != null ? fa.name() : attr.name();
    }

    private FieldExtraction topHitFieldRef(FieldAttribute fieldAttr) {
        return new SearchHitFieldRef(this.aliasName((Attribute)fieldAttr), fieldAttr.field().getDataType());
    }

    private Tuple<QueryContainer, FieldExtraction> nestedHitFieldRef(FieldAttribute attr) {
        String name = this.aliasName((Attribute)attr);
        Query q = QueryContainer.rewriteToContainNestedField(this.query, attr.source(), attr.nestedParent().name(), name, SqlDataTypes.format(attr.field().getDataType()), SqlDataTypes.isFromDocValuesOnly(attr.field().getDataType()));
        SearchHitFieldRef nestedFieldRef = new SearchHitFieldRef(name, attr.field().getDataType(), attr.nestedParent().name());
        return new Tuple((Object)new QueryContainer(q, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize), (Object)nestedFieldRef);
    }

    static Query rewriteToContainNestedField(@Nullable Query query, Source source, String path, String name, String format, boolean hasDocValues) {
        if (query == null) {
            return new NestedQuery(source, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), (Query)new MatchAll(source));
        }
        if (query.containsNestedField(path, name)) {
            return query;
        }
        Query rewritten = query.addNestedField(path, name, format, hasDocValues);
        if (rewritten != query) {
            return rewritten;
        }
        NestedQuery nested = new NestedQuery(source, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), (Query)new MatchAll(source));
        return new BoolQuery(source, true, query, (Query)nested);
    }

    private Tuple<QueryContainer, FieldExtraction> resolvedTreeComputingRef(ScalarFunction function, Attribute attr) {
        Pipe proc = null;
        proc = (Pipe)this.scalarFunctions.resolve((Object)attr);
        if (proc == null) {
            proc = function.asPipe();
            this.scalarFunctions = AttributeMap.builder(this.scalarFunctions).put(attr, (Object)proc).build();
        }
        class QueryAttributeResolver
        implements Pipe.AttributeResolver {
            private QueryContainer container;

            QueryAttributeResolver(QueryContainer container) {
                this.container = container;
            }

            public FieldExtraction resolve(Attribute attribute) {
                Tuple ref = this.container.asFieldExtraction(attribute);
                this.container = (QueryContainer)ref.v1();
                return (FieldExtraction)ref.v2();
            }
        }
        QueryAttributeResolver resolver = new QueryAttributeResolver(this);
        proc = proc.resolveAttributes((Pipe.AttributeResolver)resolver);
        QueryContainer qContainer = resolver.container;
        if (qContainer.scalarFunctions().size() != this.scalarFunctions.size()) {
            qContainer = qContainer.withScalarProcessors((AttributeMap<Pipe>)AttributeMap.builder(qContainer.scalarFunctions).put(attr, (Object)proc).build());
        }
        return new Tuple((Object)qContainer, (Object)new ComputedRef(proc));
    }

    public QueryContainer addColumn(Attribute attr) {
        Expression expression = (Expression)this.aliases.resolve((Object)attr, (Object)attr);
        Tuple<QueryContainer, FieldExtraction> tuple = this.asFieldExtraction(attr);
        return ((QueryContainer)tuple.v1()).addColumn((FieldExtraction)tuple.v2(), Expressions.id((Expression)expression));
    }

    private Tuple<QueryContainer, FieldExtraction> asFieldExtraction(Attribute attr) {
        Expression expression = (Expression)this.aliases.resolve((Object)attr, (Object)attr);
        if (expression instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)expression;
            if (fa.isNested()) {
                return this.nestedHitFieldRef(fa);
            }
            return new Tuple((Object)this, (Object)this.topHitFieldRef(fa));
        }
        if (expression == null) {
            throw new SqlIllegalArgumentException("Unknown output attribute {}", attr);
        }
        if (expression.foldable()) {
            return new Tuple((Object)this, (Object)new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, expression.fold())));
        }
        if (expression instanceof Score) {
            return new Tuple((Object)this, (Object)new ComputedRef(new ScorePipe(expression.source(), expression)));
        }
        if (expression instanceof ScalarFunction) {
            return this.resolvedTreeComputingRef((ScalarFunction)expression, attr);
        }
        throw new SqlIllegalArgumentException("Unknown output attribute {}", attr);
    }

    public QueryContainer addColumn(FieldExtraction ref, String id) {
        return new QueryContainer(this.query, this.aggs, CollectionUtils.combine(this.fields, (Object[])new Tuple[]{new Tuple((Object)ref, (Object)id)}), this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen, this.minPageSize);
    }

    public AttributeMap<Pipe> scalarFunctions() {
        return this.scalarFunctions;
    }

    public QueryContainer addAgg(String groupId, LeafAgg agg) {
        return this.with(this.aggs.addAgg(agg));
    }

    public QueryContainer addGroups(Collection<GroupByKey> values) {
        return this.with(this.aggs.addGroups(values));
    }

    public GroupByKey findGroupForAgg(String aggId) {
        return this.aggs.findGroupForAgg(aggId);
    }

    public QueryContainer updateGroup(GroupByKey group) {
        return this.with(this.aggs.updateGroup(group));
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggs, this.fields, this.aliases, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryContainer other = (QueryContainer)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.aggs, other.aggs) && Objects.equals(this.fields, other.fields) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.sort, other.sort) && Objects.equals(this.limit, other.limit) && Objects.equals(this.trackHits, other.trackHits) && Objects.equals(this.includeFrozen, other.includeFrozen);
    }

    public String toString() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.humanReadable(true).prettyPrint();
                SourceGenerator.sourceBuilder(this, null, null).toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }
}

