/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentSubParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSourceType;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateDoubleMetricFieldData;
import org.elasticsearch.xpack.aggregatemetric.fielddata.LeafAggregateDoubleMetricFieldData;

public class AggregateDoubleMetricFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "aggregate_metric_double";
    public static final String SUBFIELD_SEPARATOR = ".";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())), AggregateDoubleMetricFieldMapper.notInMultiFields((String)"aggregate_metric_double"));
    private final EnumMap<Metric, NumberFieldMapper> metricFieldMappers;
    private final boolean ignoreMalformed;
    private final boolean ignoreMalformedByDefault;
    private final Set<Metric> metrics;
    protected Metric defaultMetric;

    private static AggregateDoubleMetricFieldMapper toType(FieldMapper in) {
        return (AggregateDoubleMetricFieldMapper)in;
    }

    public static String subfieldName(String fieldName, Metric metric) {
        return fieldName + SUBFIELD_SEPARATOR + metric.name();
    }

    private AggregateDoubleMetricFieldMapper(String simpleName, MappedFieldType mappedFieldType, EnumMap<Metric, NumberFieldMapper> metricFieldMappers, Builder builder) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)builder.ignoreMalformed.getDefaultValue();
        this.metrics = (Set)builder.metrics.getValue();
        this.defaultMetric = (Metric)((Object)builder.defaultMetric.getValue());
        this.metricFieldMappers = metricFieldMappers;
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    Metric defaultMetric() {
        return this.defaultMetric;
    }

    public AggregateDoubleMetricFieldType fieldType() {
        return (AggregateDoubleMetricFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public Iterator<Mapper> iterator() {
        return Collections.emptyIterator();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        context.path().add(this.simpleName());
        XContentSubParser subParser = null;
        EnumSet<Metric> metricsParsed = EnumSet.noneOf(Metric.class);
        try {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            subParser = new XContentSubParser(context.parser());
            token = subParser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                Number n;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
                String fieldName = subParser.currentName();
                Metric metric = Metric.valueOf(fieldName);
                if (!this.metrics.contains((Object)metric)) {
                    throw new IllegalArgumentException("Aggregate metric [" + (Object)((Object)metric) + "] does not exist in the mapping of field [" + this.mappedFieldType.name() + "]");
                }
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                NumberFieldMapper delegateFieldMapper = this.metricFieldMappers.get((Object)metric);
                if (context.doc().getField(delegateFieldMapper.fieldType().name()) != null) {
                    throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support indexing multiple values for the same field in the same document");
                }
                delegateFieldMapper.parse(context);
                if (Metric.value_count == metric && (n = context.doc().getField(delegateFieldMapper.name()).numericValue()).intValue() < 0) {
                    throw new IllegalArgumentException("Aggregate metric [" + metric.name() + "] of field [" + this.mappedFieldType.name() + "] cannot be a negative number");
                }
                metricsParsed.add(metric);
                token = subParser.nextToken();
            }
            if (!metricsParsed.containsAll(this.metrics)) {
                throw new IllegalArgumentException("Aggregate metric field [" + this.mappedFieldType.name() + "] must contain all metrics " + this.metrics.toString());
            }
        }
        catch (Exception e) {
            if (this.ignoreMalformed) {
                if (subParser != null) {
                    subParser.close();
                }
                HashSet<String> ignoreFieldNames = new HashSet<String>(this.metricFieldMappers.size());
                for (NumberFieldMapper m : this.metricFieldMappers.values()) {
                    context.addIgnoredField(m.fieldType().name());
                    ignoreFieldNames.add(m.fieldType().name());
                }
                Iterator iter = context.doc().getFields().iterator();
                while (iter.hasNext()) {
                    IndexableField field = (IndexableField)iter.next();
                    if (!ignoreFieldNames.contains(field.name())) continue;
                    iter.remove();
                }
            }
            throw e;
        }
        context.path().remove();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<Set<Metric>> metrics = new FieldMapper.Parameter("metrics", false, () -> Defaults.METRICS, (n, c, o) -> {
            List metricsList = (List)o;
            EnumSet<Metric> parsedMetrics = EnumSet.noneOf(Metric.class);
            for (String s : metricsList) {
                try {
                    Metric m = Metric.valueOf(s);
                    parsedMetrics.add(m);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Metric [" + s + "] is not supported.", e);
                }
            }
            return parsedMetrics;
        }, m -> AggregateDoubleMetricFieldMapper.access$400(AggregateDoubleMetricFieldMapper.toType(m))).setValidator(v -> {
            if (v == null || v.isEmpty()) {
                throw new IllegalArgumentException("Property [metrics] is required for field [" + this.name() + "].");
            }
        });
        private final FieldMapper.Parameter<Metric> defaultMetric = new FieldMapper.Parameter("default_metric", false, () -> null, (n, c, o) -> {
            try {
                return Metric.valueOf(o.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Metric [" + o.toString() + "] is not supported.", e);
            }
        }, m -> AggregateDoubleMetricFieldMapper.toType((FieldMapper)m).defaultMetric);

        public Builder(String name, Boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam((String)"ignore_malformed", (boolean)true, m -> AggregateDoubleMetricFieldMapper.toType(m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return org.elasticsearch.core.List.of((Object[])new FieldMapper.Parameter[]{this.ignoreMalformed, this.metrics, this.defaultMetric, this.meta});
        }

        public AggregateDoubleMetricFieldMapper build(ContentPath context) {
            if (!this.defaultMetric.isConfigured()) {
                if (((Set)this.metrics.getValue()).size() == 1) {
                    Metric m = (Metric)((Object)((Set)this.metrics.getValue()).iterator().next());
                    this.defaultMetric.setValue((Object)m);
                }
                if (!((Set)this.metrics.getValue()).contains(this.defaultMetric.getValue())) {
                    throw new IllegalArgumentException("Property [default_metric] is required for field [" + this.name() + "].");
                }
            }
            if (!((Set)this.metrics.getValue()).contains(this.defaultMetric.getValue())) {
                throw new IllegalArgumentException("Default metric [" + this.defaultMetric.getValue() + "] is not defined in the metrics of field [" + this.name() + "].");
            }
            EnumMap<Metric, NumberFieldMapper> metricMappers = new EnumMap<Metric, NumberFieldMapper>(Metric.class);
            for (Metric m : (Set)this.metrics.getValue()) {
                String fieldName = AggregateDoubleMetricFieldMapper.subfieldName(this.name, m);
                NumberFieldMapper.Builder builder = m == Metric.value_count ? new NumberFieldMapper.Builder(fieldName, NumberFieldMapper.NumberType.INTEGER, ScriptCompiler.NONE, false, false) : new NumberFieldMapper.Builder(fieldName, NumberFieldMapper.NumberType.DOUBLE, ScriptCompiler.NONE, false, true);
                NumberFieldMapper fieldMapper = builder.build(context);
                metricMappers.put(m, fieldMapper);
            }
            EnumMap metricFields = metricMappers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NumberFieldMapper)e.getValue()).fieldType(), (l, r) -> {
                throw new IllegalArgumentException("Duplicate keys " + l + "and " + r + AggregateDoubleMetricFieldMapper.SUBFIELD_SEPARATOR);
            }, () -> new EnumMap(Metric.class)));
            AggregateDoubleMetricFieldType metricFieldType = new AggregateDoubleMetricFieldType(this.buildFullName(context), (Map)this.meta.getValue());
            metricFieldType.setMetricFields(metricFields);
            metricFieldType.setDefaultMetric((Metric)((Object)this.defaultMetric.getValue()));
            return new AggregateDoubleMetricFieldMapper(this.name, (MappedFieldType)metricFieldType, metricMappers, this);
        }
    }

    public static enum Metric {
        min,
        max,
        sum,
        value_count;

    }

    public static final class AggregateDoubleMetricFieldType
    extends SimpleMappedFieldType {
        private EnumMap<Metric, NumberFieldMapper.NumberFieldType> metricFields;
        private Metric defaultMetric;

        public AggregateDoubleMetricFieldType(String name) {
            this(name, Collections.emptyMap());
        }

        public AggregateDoubleMetricFieldType(String name, Map<String, String> meta) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
        }

        private NumberFieldMapper.NumberFieldType delegateFieldType(Metric metric) {
            return this.metricFields.get((Object)metric);
        }

        private NumberFieldMapper.NumberFieldType delegateFieldType() {
            return this.delegateFieldType(this.defaultMetric);
        }

        public String familyTypeName() {
            return NumberFieldMapper.NumberType.DOUBLE.typeName();
        }

        public String typeName() {
            return AggregateDoubleMetricFieldMapper.CONTENT_TYPE;
        }

        private void setMetricFields(EnumMap<Metric, NumberFieldMapper.NumberFieldType> metricFields) {
            this.metricFields = metricFields;
        }

        public void addMetricField(Metric m, NumberFieldMapper.NumberFieldType subfield) {
            if (this.metricFields == null) {
                this.metricFields = new EnumMap(Metric.class);
            }
            if (this.name() == null) {
                throw new IllegalArgumentException("Field of type [" + this.typeName() + "] must have a name before adding a subfield");
            }
            this.metricFields.put(m, subfield);
        }

        public void setDefaultMetric(Metric defaultMetric) {
            this.defaultMetric = defaultMetric;
        }

        Metric getDefaultMetric() {
            return this.defaultMetric;
        }

        public Query existsQuery(SearchExecutionContext context) {
            return this.delegateFieldType().existsQuery(context);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot search for null.");
            }
            return this.delegateFieldType().termQuery(value, context);
        }

        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            return this.delegateFieldType().termsQuery(values, context);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            return this.delegateFieldType().rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        public Object valueForDisplay(Object value) {
            return this.delegateFieldType().valueForDisplay(value);
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return this.delegateFieldType().docValueFormat(format, timeZone);
        }

        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateMathParser, QueryRewriteContext context) throws IOException {
            return this.delegateFieldType().isFieldWithinQuery(reader, from, to, includeLower, includeUpper, timeZone, dateMathParser, context);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return (cache, breakerService) -> new IndexAggregateDoubleMetricFieldData(this.name(), AggregateMetricsValuesSourceType.AGGREGATE_METRIC){

                public LeafAggregateDoubleMetricFieldData load(final LeafReaderContext context) {
                    return new LeafAggregateDoubleMetricFieldData(){

                        @Override
                        public SortedNumericDoubleValues getAggregateMetricValues(final Metric metric) {
                            try {
                                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)AggregateDoubleMetricFieldMapper.subfieldName(this.getFieldName(), metric));
                                return new SortedNumericDoubleValues(){

                                    public int docValueCount() {
                                        return values.docValueCount();
                                    }

                                    public boolean advanceExact(int doc) throws IOException {
                                        return values.advanceExact(doc);
                                    }

                                    public double nextValue() throws IOException {
                                        long v = values.nextValue();
                                        if (metric == Metric.value_count) {
                                            return v;
                                        }
                                        return NumericUtils.sortableLongToDouble((long)v);
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new IllegalStateException("Cannot load doc values", e);
                            }
                        }

                        public ScriptDocValues<?> getScriptValues() {
                            return new ScriptDocValues.Doubles(this.getAggregateMetricValues(defaultMetric));
                        }

                        public SortedBinaryDocValues getBytesValues() {
                            throw new UnsupportedOperationException("String representation of doc values for [aggregate_metric_double] fields is not supported");
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }

                        public void close() {
                        }
                    };
                }

                public LeafAggregateDoubleMetricFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    return new SortedNumericSortField(this.delegateFieldType().name(), SortField.Type.DOUBLE, reverse);
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("Can't sort on the [aggregate_metric_double] field");
                }
            };
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context){

                protected Object parseSourceValue(Object value) {
                    Map metrics = (Map)value;
                    return metrics.get(defaultMetric.name());
                }
            };
        }
    }

    public static class Defaults {
        public static final Set<Metric> METRICS = Collections.emptySet();
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
        public static final String METRICS = "metrics";
        public static final String DEFAULT_METRIC = "default_metric";
    }
}

