/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.frozen.FrozenEngine;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.sourceonly.SourceOnlySnapshotRepository;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotAction;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsFeatureSet;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.action.ClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.action.RepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.SearchableSnapshotsStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportMountSearchableSnapshotAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportRepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.TransportSearchableSnapshotsStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoNodeAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.TransportSearchableSnapshotCacheStoresAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.TransportSearchableSnapshotsNodeCachesStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.allocation.FailShardsOnInvalidLicenseClusterListener;
import org.elasticsearch.xpack.searchablesnapshots.allocation.SearchableSnapshotAllocator;
import org.elasticsearch.xpack.searchablesnapshots.allocation.SearchableSnapshotIndexEventListener;
import org.elasticsearch.xpack.searchablesnapshots.allocation.SearchableSnapshotIndexFoldersDeletionListener;
import org.elasticsearch.xpack.searchablesnapshots.allocation.decider.DedicatedFrozenNodeAllocationDecider;
import org.elasticsearch.xpack.searchablesnapshots.allocation.decider.HasFrozenCacheAllocationDecider;
import org.elasticsearch.xpack.searchablesnapshots.allocation.decider.SearchableSnapshotAllocationDecider;
import org.elasticsearch.xpack.searchablesnapshots.allocation.decider.SearchableSnapshotEnableAllocationDecider;
import org.elasticsearch.xpack.searchablesnapshots.allocation.decider.SearchableSnapshotRepositoryExistsAllocationDecider;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.BlobStoreCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.PersistentCache;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheInfoService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;
import org.elasticsearch.xpack.searchablesnapshots.recovery.SearchableSnapshotRecoveryState;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestClearSearchableSnapshotsCacheAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestMountSearchableSnapshotAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestRepositoryStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestSearchableSnapshotsNodeCachesStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.rest.RestSearchableSnapshotsStatsAction;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.upgrade.SearchableSnapshotIndexMetadataUpgrader;

public class SearchableSnapshots
extends Plugin
implements IndexStorePlugin,
EnginePlugin,
ActionPlugin,
ClusterPlugin,
SystemIndexPlugin {
    public static final Setting<String> SNAPSHOT_REPOSITORY_NAME_SETTING = Setting.simpleString((String)"index.store.snapshot.repository_name", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_REPOSITORY_UUID_SETTING = Setting.simpleString((String)"index.store.snapshot.repository_uuid", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_SNAPSHOT_NAME_SETTING = Setting.simpleString((String)"index.store.snapshot.snapshot_name", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_SNAPSHOT_ID_SETTING = Setting.simpleString((String)"index.store.snapshot.snapshot_uuid", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_INDEX_NAME_SETTING = Setting.simpleString((String)"index.store.snapshot.index_name", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<String> SNAPSHOT_INDEX_ID_SETTING = Setting.simpleString((String)"index.store.snapshot.index_uuid", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});
    public static final Setting<Boolean> SNAPSHOT_CACHE_ENABLED_SETTING = Setting.boolSetting((String)"index.store.snapshot.cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<Boolean> SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING = Setting.boolSetting((String)"index.store.snapshot.cache.prewarm.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<java.util.List<String>> SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING = Setting.listSetting((String)"index.store.snapshot.cache.excluded_file_types", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.NotCopyableOnResize});
    public static final Setting<ByteSizeValue> SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"index.store.snapshot.uncached_chunk_size", (ByteSizeValue)new ByteSizeValue(-1L, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.NotCopyableOnResize});
    public static final String SNAPSHOT_BLOB_CACHE_INDEX = ".snapshot-blob-cache";
    public static final String SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH = "index.store.snapshot.blob_cache.metadata_files.max_length";
    public static final Setting<ByteSizeValue> SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH_SETTING = new Setting((Setting.Key)new Setting.SimpleKey("index.store.snapshot.blob_cache.metadata_files.max_length"), s -> new ByteSizeValue(64L, ByteSizeUnit.KB).getStringRep(), s -> Setting.parseByteSize((String)s, (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.KB), (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE), (String)SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH), value -> {
        if (value.getBytes() % 1024L != 0L) {
            String message = String.format(Locale.ROOT, "failed to parse value [%s] for setting [%s], must be a multiple of [%s] bytes", value.getStringRep(), SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH, 1024);
            throw new IllegalArgumentException(message);
        }
    }, new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize});
    public static final String DATA_TIERS_CACHE_INDEX_PREFERENCE = String.join((CharSequence)",", "data_content", "data_hot");
    private volatile Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final SetOnce<BlobStoreCacheService> blobStoreCacheService = new SetOnce();
    private final SetOnce<CacheService> cacheService = new SetOnce();
    private final SetOnce<FrozenCacheService> frozenCacheService = new SetOnce();
    private final SetOnce<ThreadPool> threadPool = new SetOnce();
    private final SetOnce<FailShardsOnInvalidLicenseClusterListener> failShardsListener = new SetOnce();
    private final SetOnce<SearchableSnapshotAllocator> allocator = new SetOnce();
    private final Settings settings;
    private final FrozenCacheInfoService frozenCacheInfoService = new FrozenCacheInfoService();
    private final boolean transportClientMode;
    public static final String SNAPSHOT_RECOVERY_STATE_FACTORY_KEY = "snapshot_prewarm";
    public static final String CACHE_FETCH_ASYNC_THREAD_POOL_NAME = "searchable_snapshots_cache_fetch_async";
    public static final String CACHE_FETCH_ASYNC_THREAD_POOL_SETTING = "xpack.searchable_snapshots.cache_fetch_async_thread_pool";
    public static final String CACHE_PREWARMING_THREAD_POOL_NAME = "searchable_snapshots_cache_prewarming";
    public static final String CACHE_PREWARMING_THREAD_POOL_SETTING = "xpack.searchable_snapshots.cache_prewarming_thread_pool";

    public SearchableSnapshots(Settings settings) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public static void ensureValidLicense(XPackLicenseState licenseState) {
        if (!licenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS)) {
            throw LicenseUtils.newComplianceException((String)"searchable-snapshots");
        }
    }

    public static BlobStoreRepository getSearchableRepository(Repository repository) {
        if (repository instanceof SourceOnlySnapshotRepository) {
            repository = ((SourceOnlySnapshotRepository)repository).getDelegate();
        }
        if (!(repository instanceof BlobStoreRepository)) {
            throw new IllegalArgumentException("Repository [" + repository + "] is not searchable");
        }
        return (BlobStoreRepository)repository;
    }

    public java.util.List<Setting<?>> getSettings() {
        return List.of((Object[])new Setting[]{SNAPSHOT_REPOSITORY_UUID_SETTING, SNAPSHOT_REPOSITORY_NAME_SETTING, SNAPSHOT_SNAPSHOT_NAME_SETTING, SNAPSHOT_SNAPSHOT_ID_SETTING, SNAPSHOT_INDEX_NAME_SETTING, SNAPSHOT_INDEX_ID_SETTING, SNAPSHOT_CACHE_ENABLED_SETTING, SNAPSHOT_CACHE_PREWARM_ENABLED_SETTING, SNAPSHOT_CACHE_EXCLUDED_FILE_TYPES_SETTING, SNAPSHOT_UNCACHED_CHUNK_SIZE_SETTING, SearchableSnapshotsConstants.SNAPSHOT_PARTIAL_SETTING, SNAPSHOT_BLOB_CACHE_METADATA_FILES_MAX_LENGTH_SETTING, CacheService.SNAPSHOT_CACHE_RANGE_SIZE_SETTING, CacheService.SNAPSHOT_CACHE_RECOVERY_RANGE_SIZE_SETTING, CacheService.SNAPSHOT_CACHE_SYNC_INTERVAL_SETTING, CacheService.SNAPSHOT_CACHE_MAX_FILES_TO_SYNC_AT_ONCE_SETTING, CacheService.SNAPSHOT_CACHE_SYNC_SHUTDOWN_TIMEOUT, SearchableSnapshotEnableAllocationDecider.SEARCHABLE_SNAPSHOTS_ALLOCATE_ON_ROLLING_RESTART, FrozenCacheService.SNAPSHOT_CACHE_SIZE_SETTING, FrozenCacheService.SNAPSHOT_CACHE_SIZE_MAX_HEADROOM_SETTING, FrozenCacheService.SNAPSHOT_CACHE_REGION_SIZE_SETTING, FrozenCacheService.SHARED_CACHE_RANGE_SIZE_SETTING, FrozenCacheService.FROZEN_CACHE_RECOVERY_RANGE_SIZE_SETTING, FrozenCacheService.SNAPSHOT_CACHE_MAX_FREQ_SETTING, FrozenCacheService.SNAPSHOT_CACHE_DECAY_INTERVAL_SETTING, FrozenCacheService.SNAPSHOT_CACHE_MIN_TIME_DELTA_SETTING});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry registry, IndexNameExpressionResolver resolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        ArrayList<Object> components = new ArrayList<Object>();
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        this.threadPool.set((Object)threadPool);
        this.failShardsListener.set((Object)new FailShardsOnInvalidLicenseClusterListener(this.getLicenseState(), clusterService.getRerouteService()));
        if (DiscoveryNode.canContainData((Settings)this.settings)) {
            CacheService cacheService = new CacheService(this.settings, clusterService, threadPool, new PersistentCache(nodeEnvironment));
            this.cacheService.set((Object)cacheService);
            FrozenCacheService frozenCacheService = new FrozenCacheService(nodeEnvironment, this.settings, threadPool);
            this.frozenCacheService.set((Object)frozenCacheService);
            components.add((Object)cacheService);
            BlobStoreCacheService blobStoreCacheService = new BlobStoreCacheService(clusterService, client, SNAPSHOT_BLOB_CACHE_INDEX, () -> ((ThreadPool)threadPool).absoluteTimeInMillis());
            this.blobStoreCacheService.set((Object)blobStoreCacheService);
            components.add((Object)blobStoreCacheService);
        } else {
            PersistentCache.cleanUp(this.settings, nodeEnvironment);
        }
        this.allocator.set((Object)new SearchableSnapshotAllocator(client, clusterService.getRerouteService(), this.frozenCacheInfoService));
        components.add(new FrozenCacheServiceSupplier((FrozenCacheService)this.frozenCacheService.get()));
        components.add(new CacheServiceSupplier((CacheService)((Object)this.cacheService.get())));
        if (DiscoveryNode.isMasterNode((Settings)this.settings)) {
            new SearchableSnapshotIndexMetadataUpgrader(clusterService, threadPool).initialize();
            clusterService.addListener((ClusterStateListener)new RepositoryUuidWatcher(clusterService.getRerouteService()));
        }
        return Collections.unmodifiableList(components);
    }

    public Collection<Module> createGuiceModules() {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        return Collections.singleton(b -> XPackPlugin.bindFeatureSet((Binder)b, SearchableSnapshotsFeatureSet.class));
    }

    public void onIndexModule(IndexModule indexModule) {
        if (SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexModule.getSettings())) {
            indexModule.addIndexEventListener((IndexEventListener)new SearchableSnapshotIndexEventListener(this.settings, (CacheService)((Object)this.cacheService.get()), (FrozenCacheService)this.frozenCacheService.get()));
            indexModule.addIndexEventListener((IndexEventListener)this.failShardsListener.get());
            indexModule.addSettingsUpdateConsumer(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, s -> {}, write -> {
                if (!write.booleanValue()) {
                    throw new IllegalArgumentException("Cannot remove write block from searchable snapshot index");
                }
            });
        }
    }

    public java.util.List<IndexStorePlugin.IndexFoldersDeletionListener> getIndexFoldersDeletionListeners() {
        if (DiscoveryNode.canContainData((Settings)this.settings)) {
            return List.of((Object)new SearchableSnapshotIndexFoldersDeletionListener(() -> this.cacheService.get(), () -> this.frozenCacheService.get()));
        }
        return Collections.emptyList();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of((Object)SystemIndexDescriptor.builder().setIndexPattern(SNAPSHOT_BLOB_CACHE_INDEX).setDescription("Contains cached data of blob store repositories").setPrimaryIndex(SNAPSHOT_BLOB_CACHE_INDEX).setMappings(this.getIndexMappings()).setSettings(this.getIndexSettings()).setOrigin("searchable_snapshots").setVersionMetaKey("version").build());
    }

    public String getFeatureName() {
        return "searchable_snapshots";
    }

    public String getFeatureDescription() {
        return "Manages caches and configuration for searchable snapshots";
    }

    public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
        return org.elasticsearch.core.Map.of((Object)"snapshot", (indexSettings, shardPath) -> {
            RepositoriesService repositories = this.repositoriesServiceSupplier.get();
            assert (repositories != null);
            CacheService cache = (CacheService)((Object)((Object)this.cacheService.get()));
            assert (cache != null);
            ThreadPool threadPool = (ThreadPool)this.threadPool.get();
            assert (threadPool != null);
            BlobStoreCacheService blobCache = (BlobStoreCacheService)((Object)((Object)this.blobStoreCacheService.get()));
            assert (blobCache != null);
            return SearchableSnapshotDirectory.create(repositories, cache, indexSettings, shardPath, System::nanoTime, threadPool, blobCache, (FrozenCacheService)this.frozenCacheService.get());
        });
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexSettings.getSettings())) {
            boolean useFrozenEngine;
            Boolean frozen = indexSettings.getSettings().getAsBoolean("index.frozen", null);
            boolean bl = useFrozenEngine = SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex((Settings)indexSettings.getSettings()) && (frozen == null || frozen.equals(Boolean.TRUE));
            if (useFrozenEngine) {
                return Optional.of(engineConfig -> new FrozenEngine(engineConfig, null, new TranslogStats(), false, (Boolean)indexSettings.getValue(SourceOnlySnapshotRepository.SOURCE_ONLY) != false ? SourceOnlySnapshotRepository.readerWrapper((EngineConfig)engineConfig) : Function.identity(), false, true));
            }
            return Optional.of(engineConfig -> new ReadOnlyEngine(engineConfig, null, new TranslogStats(), false, (Boolean)indexSettings.getValue(SourceOnlySnapshotRepository.SOURCE_ONLY) != false ? SourceOnlySnapshotRepository.readerWrapper((EngineConfig)engineConfig) : Function.identity(), false, true));
        }
        return Optional.empty();
    }

    public Map<String, IndexStorePlugin.SnapshotCommitSupplier> getSnapshotCommitSuppliers() {
        return org.elasticsearch.core.Map.of((Object)"snapshot", e -> {
            Store store = e.config().getStore();
            store.incRef();
            return new Engine.IndexCommitRef(SearchableSnapshotsUtils.emptyIndexCommit(store.directory()), () -> ((Store)store).decRef());
        });
    }

    public java.util.List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of((Object[])new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)SearchableSnapshotsStatsAction.INSTANCE, TransportSearchableSnapshotsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearSearchableSnapshotsCacheAction.INSTANCE, TransportClearSearchableSnapshotsCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MountSearchableSnapshotAction.INSTANCE, TransportMountSearchableSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RepositoryStatsAction.INSTANCE, TransportRepositoryStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler(TransportSearchableSnapshotCacheStoresAction.TYPE, TransportSearchableSnapshotCacheStoresAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FrozenCacheInfoAction.INSTANCE, FrozenCacheInfoAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FrozenCacheInfoNodeAction.INSTANCE, FrozenCacheInfoNodeAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler(TransportSearchableSnapshotsNodeCachesStatsAction.TYPE, TransportSearchableSnapshotsNodeCachesStatsAction.class, new Class[0])});
    }

    public java.util.List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of((Object[])new RestHandler[]{new RestSearchableSnapshotsStatsAction(), new RestClearSearchableSnapshotsCacheAction(), new RestMountSearchableSnapshotAction(), new RestSearchableSnapshotsNodeCachesStatsAction(), new RestRepositoryStatsAction()});
    }

    public Map<String, ExistingShardsAllocator> getExistingShardsAllocators() {
        return org.elasticsearch.core.Map.of((Object)"searchable_snapshot_allocator", (Object)((ExistingShardsAllocator)this.allocator.get()));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        return List.of((Object[])new AllocationDecider[]{new SearchableSnapshotAllocationDecider(() -> this.getLicenseState().isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS)), new SearchableSnapshotRepositoryExistsAllocationDecider(), new SearchableSnapshotEnableAllocationDecider(settings, clusterSettings), new HasFrozenCacheAllocationDecider(this.frozenCacheInfoService), new DedicatedFrozenNodeAllocationDecider()});
    }

    public java.util.List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of((Object[])SearchableSnapshots.executorBuilders(settings));
    }

    public Map<String, IndexStorePlugin.RecoveryStateFactory> getRecoveryStateFactories() {
        return Collections.singletonMap(SNAPSHOT_RECOVERY_STATE_FACTORY_KEY, SearchableSnapshotRecoveryState::new);
    }

    public static ScalingExecutorBuilder[] executorBuilders(Settings settings) {
        int processors = EsExecutors.allocatedProcessors((Settings)settings);
        return new ScalingExecutorBuilder[]{new ScalingExecutorBuilder(CACHE_FETCH_ASYNC_THREAD_POOL_NAME, 0, Math.min(processors * 3, 50), TimeValue.timeValueSeconds((long)30L), CACHE_FETCH_ASYNC_THREAD_POOL_SETTING), new ScalingExecutorBuilder(CACHE_PREWARMING_THREAD_POOL_NAME, 0, 16, TimeValue.timeValueSeconds((long)30L), CACHE_PREWARMING_THREAD_POOL_SETTING)};
    }

    private Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.priority", "900").put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)Translog.Durability.ASYNC).put("index.routing.allocation.include._tier_preference", DATA_TIERS_CACHE_INDEX_PREFERENCE).build();
    }

    private XContentBuilder getIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.field("dynamic", "strict");
            builder.startObject("_meta");
            builder.field("version", (ToXContent)Version.CURRENT);
            builder.endObject();
            builder.startObject("properties");
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("creation_time");
            builder.field("type", "date");
            builder.field("format", "epoch_millis");
            builder.endObject();
            builder.startObject("version");
            builder.field("type", "integer");
            builder.endObject();
            builder.startObject("repository");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("blob");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("name");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("path");
            builder.field("type", "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("data");
            builder.field("type", "object");
            builder.startObject("properties");
            builder.startObject("content");
            builder.field("type", "binary");
            builder.endObject();
            builder.startObject("length");
            builder.field("type", "long");
            builder.endObject();
            builder.startObject("from");
            builder.field("type", "long");
            builder.endObject();
            builder.startObject("to");
            builder.field("type", "long");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .snapshot-blob-cache index mappings", e);
        }
    }

    public void close() throws IOException {
        Releasables.close((Releasable)((Releasable)this.frozenCacheService.get()));
    }

    public static final class FrozenCacheServiceSupplier
    implements Supplier<FrozenCacheService> {
        @Nullable
        private final FrozenCacheService frozenCacheService;

        FrozenCacheServiceSupplier(@Nullable FrozenCacheService frozenCacheService) {
            this.frozenCacheService = frozenCacheService;
        }

        @Override
        public FrozenCacheService get() {
            return this.frozenCacheService;
        }
    }

    public static final class CacheServiceSupplier
    implements Supplier<CacheService> {
        @Nullable
        private final CacheService cacheService;

        CacheServiceSupplier(@Nullable CacheService cacheService) {
            this.cacheService = cacheService;
        }

        @Override
        public CacheService get() {
            return this.cacheService;
        }
    }

    private static final class RepositoryUuidWatcher
    implements ClusterStateListener {
        private final RerouteService rerouteService;
        private final HashSet<String> knownUuids = new HashSet();

        RepositoryUuidWatcher(RerouteService rerouteService) {
            this.rerouteService = rerouteService;
        }

        public void clusterChanged(ClusterChangedEvent event) {
            RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)event.state().metadata().custom("repositories");
            if (repositoriesMetadata == null) {
                this.knownUuids.clear();
                return;
            }
            Set newUuids = repositoriesMetadata.repositories().stream().map(RepositoryMetadata::uuid).filter(s -> !s.equals("_na_")).collect(Collectors.toSet());
            if (this.knownUuids.addAll(newUuids)) {
                this.rerouteService.reroute("repository UUIDs changed", Priority.NORMAL, ActionListener.wrap(() -> {}));
            }
            this.knownUuids.retainAll(newUuids);
            assert (this.knownUuids.equals(newUuids)) : this.knownUuids + " vs " + newUuids;
        }
    }
}

