/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.shared;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.IntConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.Preallocate;

public class SharedBytes
extends AbstractRefCounted {
    private static final Logger logger = LogManager.getLogger(SharedBytes.class);
    public static int PAGE_SIZE = 4096;
    private static final String CACHE_FILE_NAME = "shared_snapshot_cache";
    private static final StandardOpenOption[] OPEN_OPTIONS = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
    final int numRegions;
    final long regionSize;
    private final FileChannel fileChannel;
    private final Path path;
    private final IntConsumer writeBytes;
    private final IntConsumer readBytes;
    private final Map<Integer, IO> ios = ConcurrentCollections.newConcurrentMap();

    SharedBytes(int numRegions, long regionSize, NodeEnvironment environment, IntConsumer writeBytes, IntConsumer readBytes) throws IOException {
        super("shared-bytes");
        this.numRegions = numRegions;
        this.regionSize = regionSize;
        long fileSize = (long)numRegions * regionSize;
        Path cacheFile = null;
        if (fileSize > 0L) {
            cacheFile = SharedBytes.findCacheSnapshotCacheFilePath(environment, fileSize);
            Preallocate.preallocate((Path)cacheFile, (long)fileSize);
            this.fileChannel = FileChannel.open(cacheFile, OPEN_OPTIONS);
            assert (this.fileChannel.size() == fileSize) : "expected file size " + fileSize + " but was " + this.fileChannel.size();
        } else {
            this.fileChannel = null;
            for (Path path : environment.nodeDataPaths()) {
                Files.deleteIfExists(path.resolve(CACHE_FILE_NAME));
            }
        }
        this.path = cacheFile;
        this.writeBytes = writeBytes;
        this.readBytes = readBytes;
    }

    public static Path findCacheSnapshotCacheFilePath(NodeEnvironment environment, long fileSize) throws IOException {
        assert (environment.nodeDataPaths().length == 1);
        Path path = environment.nodeDataPaths()[0];
        Files.createDirectories(path, new FileAttribute[0]);
        long usableSpace = Environment.getUsableSpace((Path)path);
        Path p = path.resolve(CACHE_FILE_NAME);
        if (Files.exists(p, new LinkOption[0])) {
            usableSpace += Files.size(p);
        }
        if (usableSpace > fileSize) {
            return p;
        }
        throw new IOException("Not enough free space for cache file of size [" + fileSize + "] in path [" + path + "]");
    }

    protected void closeInternal() {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.fileChannel, this.path == null ? null : () -> Files.deleteIfExists(this.path)});
        }
        catch (IOException e) {
            logger.warn("Failed to clean up shared bytes file", (Throwable)e);
        }
    }

    IO getFileChannel(int sharedBytesPos) {
        assert (this.fileChannel != null);
        return this.ios.compute(sharedBytesPos, (p, io) -> {
            if (io == null || !io.tryIncRef()) {
                IO newIO;
                boolean success = false;
                this.incRef();
                try {
                    newIO = new IO((int)p);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.decRef();
                    }
                }
                return newIO;
            }
            return io;
        });
    }

    long getPhysicalOffset(long chunkPosition) {
        long physicalOffset = chunkPosition * this.regionSize;
        assert (physicalOffset <= (long)this.numRegions * this.regionSize);
        return physicalOffset;
    }

    public static ByteSizeValue pageAligned(ByteSizeValue val) {
        long remainder = val.getBytes() % (long)PAGE_SIZE;
        if (remainder != 0L) {
            return ByteSizeValue.ofBytes((long)(val.getBytes() + (long)PAGE_SIZE - remainder));
        }
        return val;
    }

    public final class IO
    extends AbstractRefCounted {
        private final int sharedBytesPos;
        private final long pageStart;

        private IO(int sharedBytesPos) {
            super("shared-bytes-io");
            this.sharedBytesPos = sharedBytesPos;
            this.pageStart = SharedBytes.this.getPhysicalOffset(sharedBytesPos);
        }

        @SuppressForbidden(reason="Use positional reads on purpose")
        public int read(ByteBuffer dst, long position) throws IOException {
            this.checkOffsets(position, dst.remaining());
            int bytesRead = SharedBytes.this.fileChannel.read(dst, position);
            SharedBytes.this.readBytes.accept(bytesRead);
            return bytesRead;
        }

        @SuppressForbidden(reason="Use positional writes on purpose")
        public int write(ByteBuffer src, long position) throws IOException {
            assert (position % (long)PAGE_SIZE == 0L);
            assert (src.remaining() % PAGE_SIZE == 0);
            this.checkOffsets(position, src.remaining());
            int bytesWritten = SharedBytes.this.fileChannel.write(src, position);
            SharedBytes.this.writeBytes.accept(bytesWritten);
            return bytesWritten;
        }

        private void checkOffsets(long position, long length) {
            long pageEnd = this.pageStart + SharedBytes.this.regionSize;
            if (position < this.pageStart || position > pageEnd || position + length > pageEnd) {
                assert (false);
                throw new IllegalArgumentException("bad access");
            }
        }

        protected void closeInternal() {
            SharedBytes.this.ios.remove(this.sharedBytesPos, (Object)this);
            SharedBytes.this.decRef();
        }
    }
}

