/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BinaryMathNode;
import org.elasticsearch.painless.ir.BooleanNode;
import org.elasticsearch.painless.ir.CastNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ConditionalNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.DoWhileLoopNode;
import org.elasticsearch.painless.ir.DupNode;
import org.elasticsearch.painless.ir.ElvisNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FlipArrayIndexNode;
import org.elasticsearch.painless.ir.FlipCollectionIndexNode;
import org.elasticsearch.painless.ir.FlipDefIndexNode;
import org.elasticsearch.painless.ir.ForEachSubArrayNode;
import org.elasticsearch.painless.ir.ForEachSubIterableNode;
import org.elasticsearch.painless.ir.ForLoopNode;
import org.elasticsearch.painless.ir.IfElseNode;
import org.elasticsearch.painless.ir.IfNode;
import org.elasticsearch.painless.ir.InstanceofNode;
import org.elasticsearch.painless.ir.InvokeCallDefNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.ListInitializationNode;
import org.elasticsearch.painless.ir.MapInitializationNode;
import org.elasticsearch.painless.ir.NewArrayNode;
import org.elasticsearch.painless.ir.NewObjectNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.NullSafeSubNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StatementExpressionNode;
import org.elasticsearch.painless.ir.StoreBraceDefNode;
import org.elasticsearch.painless.ir.StoreBraceNode;
import org.elasticsearch.painless.ir.StoreDotDefNode;
import org.elasticsearch.painless.ir.StoreDotNode;
import org.elasticsearch.painless.ir.StoreDotShortcutNode;
import org.elasticsearch.painless.ir.StoreFieldMemberNode;
import org.elasticsearch.painless.ir.StoreListShortcutNode;
import org.elasticsearch.painless.ir.StoreMapShortcutNode;
import org.elasticsearch.painless.ir.StoreVariableNode;
import org.elasticsearch.painless.ir.StringConcatenationNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.ir.WhileLoopNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRTreeBaseVisitor;
import org.elasticsearch.painless.spi.annotation.CompileTimeOnlyAnnotation;
import org.elasticsearch.painless.symbol.IRDecorations;

public class DefaultConstantFoldingOptimizationPhase
extends IRTreeBaseVisitor<Consumer<ExpressionNode>> {
    @Override
    public void visitIf(IfNode irIfNode, Consumer<ExpressionNode> scope) {
        irIfNode.getConditionNode().visit(this, irIfNode::setConditionNode);
        irIfNode.getBlockNode().visit(this, null);
    }

    @Override
    public void visitIfElse(IfElseNode irIfElseNode, Consumer<ExpressionNode> scope) {
        irIfElseNode.getConditionNode().visit(this, irIfElseNode::setConditionNode);
        irIfElseNode.getBlockNode().visit(this, null);
        irIfElseNode.getElseBlockNode().visit(this, null);
    }

    @Override
    public void visitWhileLoop(WhileLoopNode irWhileLoopNode, Consumer<ExpressionNode> scope) {
        if (irWhileLoopNode.getConditionNode() != null) {
            irWhileLoopNode.getConditionNode().visit(this, irWhileLoopNode::setConditionNode);
        }
        if (irWhileLoopNode.getBlockNode() != null) {
            irWhileLoopNode.getBlockNode().visit(this, null);
        }
    }

    @Override
    public void visitDoWhileLoop(DoWhileLoopNode irDoWhileLoopNode, Consumer<ExpressionNode> scope) {
        irDoWhileLoopNode.getBlockNode().visit(this, null);
        if (irDoWhileLoopNode.getConditionNode() != null) {
            irDoWhileLoopNode.getConditionNode().visit(this, irDoWhileLoopNode::setConditionNode);
        }
    }

    @Override
    public void visitForLoop(ForLoopNode irForLoopNode, Consumer<ExpressionNode> scope) {
        if (irForLoopNode.getInitializerNode() != null) {
            irForLoopNode.getInitializerNode().visit(this, irForLoopNode::setInitialzerNode);
        }
        if (irForLoopNode.getConditionNode() != null) {
            irForLoopNode.getConditionNode().visit(this, irForLoopNode::setConditionNode);
        }
        if (irForLoopNode.getAfterthoughtNode() != null) {
            irForLoopNode.getAfterthoughtNode().visit(this, irForLoopNode::setAfterthoughtNode);
        }
        if (irForLoopNode.getBlockNode() != null) {
            irForLoopNode.getBlockNode().visit(this, null);
        }
    }

    @Override
    public void visitForEachSubArrayLoop(ForEachSubArrayNode irForEachSubArrayNode, Consumer<ExpressionNode> scope) {
        irForEachSubArrayNode.getConditionNode().visit(this, irForEachSubArrayNode::setConditionNode);
        irForEachSubArrayNode.getBlockNode().visit(this, null);
    }

    @Override
    public void visitForEachSubIterableLoop(ForEachSubIterableNode irForEachSubIterableNode, Consumer<ExpressionNode> scope) {
        irForEachSubIterableNode.getConditionNode().visit(this, irForEachSubIterableNode::setConditionNode);
        irForEachSubIterableNode.getBlockNode().visit(this, null);
    }

    @Override
    public void visitDeclaration(DeclarationNode irDeclarationNode, Consumer<ExpressionNode> scope) {
        if (irDeclarationNode.getExpressionNode() != null) {
            irDeclarationNode.getExpressionNode().visit(this, irDeclarationNode::setExpressionNode);
        }
    }

    @Override
    public void visitReturn(ReturnNode irReturnNode, Consumer<ExpressionNode> scope) {
        if (irReturnNode.getExpressionNode() != null) {
            irReturnNode.getExpressionNode().visit(this, irReturnNode::setExpressionNode);
        }
    }

    @Override
    public void visitStatementExpression(StatementExpressionNode irStatementExpressionNode, Consumer<ExpressionNode> scope) {
        irStatementExpressionNode.getExpressionNode().visit(this, irStatementExpressionNode::setExpressionNode);
    }

    @Override
    public void visitThrow(ThrowNode irThrowNode, Consumer<ExpressionNode> scope) {
        irThrowNode.getExpressionNode().visit(this, irThrowNode::setExpressionNode);
    }

    @Override
    public void visitBinaryImpl(BinaryImplNode irBinaryImplNode, Consumer<ExpressionNode> scope) {
        irBinaryImplNode.getLeftNode().visit(this, irBinaryImplNode::setLeftNode);
        irBinaryImplNode.getRightNode().visit(this, irBinaryImplNode::setRightNode);
    }

    @Override
    public void visitUnaryMath(UnaryMathNode irUnaryMathNode, Consumer<ExpressionNode> scope) {
        irUnaryMathNode.getChildNode().visit(this, irUnaryMathNode::setChildNode);
        if (irUnaryMathNode.getChildNode() instanceof ConstantNode) {
            ConstantNode irConstantNode = (ConstantNode)irUnaryMathNode.getChildNode();
            Object constantValue = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irUnaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irUnaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.SUB) {
                if (type == Integer.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Integer)constantValue).intValue())));
                } else if (type == Long.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Long)constantValue).longValue())));
                } else if (type == Float.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(-((Float)constantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(-((Double)constantValue).doubleValue())));
                } else {
                    throw irUnaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for unary operation [" + operation.symbol + "] on constant [" + irConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irConstantNode);
            } else if (operation == Operation.BWNOT) {
                if (type == Integer.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(~((Integer)constantValue).intValue())));
                } else if (type == Long.TYPE) {
                    irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)constantValue ^ 0xFFFFFFFFFFFFFFFFL)));
                } else {
                    throw irUnaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for unary operation [" + operation.symbol + "] on constant [" + irConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irConstantNode);
            } else if (operation == Operation.NOT) {
                if (type != Boolean.TYPE) {
                    throw irUnaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for unary operation [" + operation.symbol + "] on constant [" + irConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)constantValue == false ? 1 : 0)));
                scope.accept(irConstantNode);
            } else if (operation == Operation.ADD) {
                scope.accept(irConstantNode);
            }
        }
    }

    @Override
    public void visitBinaryMath(BinaryMathNode irBinaryMathNode, Consumer<ExpressionNode> scope) {
        irBinaryMathNode.getLeftNode().visit(this, irBinaryMathNode::setLeftNode);
        irBinaryMathNode.getRightNode().visit(this, irBinaryMathNode::setRightNode);
        if (irBinaryMathNode.getLeftNode() instanceof ConstantNode && irBinaryMathNode.getRightNode() instanceof ConstantNode) {
            ConstantNode irLeftConstantNode = (ConstantNode)irBinaryMathNode.getLeftNode();
            ConstantNode irRightConstantNode = (ConstantNode)irBinaryMathNode.getRightNode();
            Object leftConstantValue = irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Object rightConstantValue = irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irBinaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irBinaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.MUL) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue * (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue * (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() * ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue * (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.DIV) {
                block84: {
                    try {
                        if (type == Integer.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue / (Integer)rightConstantValue)));
                            break block84;
                        }
                        if (type == Long.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue / (Long)rightConstantValue)));
                            break block84;
                        }
                        if (type == Float.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() / ((Float)rightConstantValue).floatValue())));
                            break block84;
                        }
                        if (type == Double.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue / (Double)rightConstantValue)));
                            break block84;
                        }
                        throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    catch (ArithmeticException ae) {
                        throw irBinaryMathNode.getLocation().createError(ae);
                    }
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.REM) {
                block85: {
                    try {
                        if (type == Integer.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue % (Integer)rightConstantValue)));
                            break block85;
                        }
                        if (type == Long.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue % (Long)rightConstantValue)));
                            break block85;
                        }
                        if (type == Float.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() % ((Float)rightConstantValue).floatValue())));
                            break block85;
                        }
                        if (type == Double.TYPE) {
                            irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue % (Double)rightConstantValue)));
                            break block85;
                        }
                        throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    catch (ArithmeticException ae) {
                        throw irBinaryMathNode.getLocation().createError(ae);
                    }
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.ADD) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue + (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue + (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() + ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue + (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.SUB) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue - (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue - (Long)rightConstantValue)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(((Float)leftConstantValue).floatValue() - ((Float)rightConstantValue).floatValue())));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue - (Double)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.LSH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue << (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue << (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.RSH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >> (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >> (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.USH) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >>> (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >>> (Integer)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.BWAND) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue & (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue & (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.XOR) {
                if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)leftConstantValue ^ (Boolean)rightConstantValue)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue ^ (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue ^ (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.BWOR) {
                if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue | (Integer)rightConstantValue)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue | (Long)rightConstantValue)));
                } else {
                    throw irBinaryMathNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                scope.accept(irLeftConstantNode);
            }
        }
    }

    @Override
    public void visitStringConcatenation(StringConcatenationNode irStringConcatenationNode, Consumer<ExpressionNode> scope) {
        ExpressionNode irArgumentNode;
        irStringConcatenationNode.getArgumentNodes().get(0).visit(this, e -> irStringConcatenationNode.getArgumentNodes().set(0, (ExpressionNode)e));
        int i = 0;
        while (i < irStringConcatenationNode.getArgumentNodes().size() - 1) {
            ConstantNode irConstantNode;
            ExpressionNode irLeftNode = irStringConcatenationNode.getArgumentNodes().get(i);
            ExpressionNode irRightNode = irStringConcatenationNode.getArgumentNodes().get(i + 1);
            int j = i;
            irRightNode.visit(this, e -> irStringConcatenationNode.getArgumentNodes().set(j + 1, (ExpressionNode)e));
            if (irLeftNode instanceof ConstantNode && irRightNode instanceof ConstantNode) {
                irConstantNode = (ConstantNode)irLeftNode;
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant("" + irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) + irRightNode.getDecorationValue(IRDecorations.IRDConstant.class)));
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            if (irLeftNode instanceof NullNode && irRightNode instanceof ConstantNode) {
                irConstantNode = (ConstantNode)irRightNode;
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant("" + null + irRightNode.getDecorationValue(IRDecorations.IRDConstant.class)));
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i);
                continue;
            }
            if (irLeftNode instanceof ConstantNode && irRightNode instanceof NullNode) {
                irConstantNode = (ConstantNode)irLeftNode;
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant("" + irLeftNode.getDecorationValue(IRDecorations.IRDConstant.class) + null));
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            if (irLeftNode instanceof NullNode && irRightNode instanceof NullNode) {
                irConstantNode = new ConstantNode(irLeftNode.getLocation());
                irConstantNode.attachDecoration(new IRDecorations.IRDConstant("" + null + null));
                irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
                irStringConcatenationNode.getArgumentNodes().set(i, irConstantNode);
                irStringConcatenationNode.getArgumentNodes().remove(i + 1);
                continue;
            }
            ++i;
        }
        if (irStringConcatenationNode.getArgumentNodes().size() == 1 && (irArgumentNode = irStringConcatenationNode.getArgumentNodes().get(0)) instanceof ConstantNode) {
            scope.accept(irArgumentNode);
        }
    }

    @Override
    public void visitBoolean(BooleanNode irBooleanNode, Consumer<ExpressionNode> scope) {
        irBooleanNode.getLeftNode().visit(this, irBooleanNode::setLeftNode);
        irBooleanNode.getRightNode().visit(this, irBooleanNode::setRightNode);
        if (irBooleanNode.getLeftNode() instanceof ConstantNode && irBooleanNode.getRightNode() instanceof ConstantNode) {
            ConstantNode irLeftConstantNode = (ConstantNode)irBooleanNode.getLeftNode();
            ConstantNode irRightConstantNode = (ConstantNode)irBooleanNode.getRightNode();
            Operation operation = (Operation)((Object)irBooleanNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irBooleanNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (operation == Operation.AND) {
                if (type != Boolean.TYPE) {
                    throw irBooleanNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for binary operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false && (Boolean)irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false ? 1 : 0)));
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.OR) {
                if (type != Boolean.TYPE) {
                    throw irBooleanNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for boolean operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Boolean)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false || (Boolean)irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class) != false ? 1 : 0)));
                scope.accept(irLeftConstantNode);
            }
        }
    }

    @Override
    public void visitComparison(ComparisonNode irComparisonNode, Consumer<ExpressionNode> scope) {
        irComparisonNode.getLeftNode().visit(this, irComparisonNode::setLeftNode);
        irComparisonNode.getRightNode().visit(this, irComparisonNode::setRightNode);
        if ((irComparisonNode.getLeftNode() instanceof ConstantNode || irComparisonNode.getLeftNode() instanceof NullNode) && (irComparisonNode.getRightNode() instanceof ConstantNode || irComparisonNode.getRightNode() instanceof NullNode)) {
            ConstantNode irLeftConstantNode = irComparisonNode.getLeftNode() instanceof NullNode ? null : (ConstantNode)irComparisonNode.getLeftNode();
            ConstantNode irRightConstantNode = irComparisonNode.getRightNode() instanceof NullNode ? null : (ConstantNode)irComparisonNode.getRightNode();
            Object leftConstantValue = irLeftConstantNode == null ? null : (Object)irLeftConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Object rightConstantValue = irRightConstantNode == null ? null : irRightConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            Operation operation = (Operation)((Object)irComparisonNode.getDecorationValue(IRDecorations.IRDOperation.class));
            Class type = (Class)irComparisonNode.getDecorationValue(IRDecorations.IRDComparisonType.class);
            if (operation == Operation.EQ || operation == Operation.EQR) {
                if (irLeftConstantNode == null && irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)true));
                } else if (irLeftConstantNode == null || irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                } else if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Boolean)leftConstantValue).booleanValue() == ((Boolean)rightConstantValue).booleanValue() ? 1 : 0)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Integer)leftConstantValue).intValue() == ((Integer)rightConstantValue).intValue() ? 1 : 0)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Long)leftConstantValue).longValue() == ((Long)rightConstantValue).longValue() ? 1 : 0)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() == ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Double)leftConstantValue).doubleValue() == ((Double)rightConstantValue).doubleValue() ? 1 : 0)));
                } else if (operation == Operation.EQ) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)leftConstantValue.equals(rightConstantValue)));
                } else {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(leftConstantValue == rightConstantValue ? 1 : 0)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                scope.accept(irLeftConstantNode);
            } else if (operation == Operation.NE || operation == Operation.NER) {
                if (irLeftConstantNode == null && irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                } else if (irLeftConstantNode == null || irRightConstantNode == null) {
                    irLeftConstantNode = new ConstantNode(irComparisonNode.getLeftNode().getLocation());
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)true));
                } else if (type == Boolean.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Boolean)leftConstantValue).booleanValue() != ((Boolean)rightConstantValue).booleanValue() ? 1 : 0)));
                } else if (type == Integer.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Integer)leftConstantValue).intValue() != ((Integer)rightConstantValue).intValue() ? 1 : 0)));
                } else if (type == Long.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Long)leftConstantValue).longValue() != ((Long)rightConstantValue).longValue() ? 1 : 0)));
                } else if (type == Float.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() != ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                } else if (type == Double.TYPE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Double)leftConstantValue).doubleValue() != ((Double)rightConstantValue).doubleValue() ? 1 : 0)));
                } else if (operation == Operation.NE) {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(!leftConstantValue.equals(rightConstantValue) ? 1 : 0)));
                } else {
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(leftConstantValue != rightConstantValue ? 1 : 0)));
                }
                irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                scope.accept(irLeftConstantNode);
            } else if (irLeftConstantNode != null && irRightConstantNode != null) {
                if (operation == Operation.GT) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue > (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue > (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() > ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue > (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for comparison operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.GTE) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue >= (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue >= (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() >= ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue >= (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for comparison operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.LT) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue < (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue < (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() < ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue < (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for comparison operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                } else if (operation == Operation.LTE) {
                    if (type == Integer.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Integer)leftConstantValue <= (Integer)rightConstantValue ? 1 : 0)));
                    } else if (type == Long.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Long)leftConstantValue <= (Long)rightConstantValue ? 1 : 0)));
                    } else if (type == Float.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)(((Float)leftConstantValue).floatValue() <= ((Float)rightConstantValue).floatValue() ? 1 : 0)));
                    } else if (type == Double.TYPE) {
                        irLeftConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)((Double)leftConstantValue <= (Double)rightConstantValue ? 1 : 0)));
                    } else {
                        throw irComparisonNode.getLocation().createError(new IllegalStateException("constant folding error: unexpected type [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] for comparison operation [" + operation.symbol + "] on constants [" + irLeftConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "] and [" + irRightConstantNode.getDecorationString(IRDecorations.IRDConstant.class) + "]"));
                    }
                    irLeftConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    scope.accept(irLeftConstantNode);
                }
            }
        }
    }

    @Override
    public void visitCast(CastNode irCastNode, Consumer<ExpressionNode> scope) {
        irCastNode.getChildNode().visit(this, irCastNode::setChildNode);
        if (irCastNode.getChildNode() instanceof ConstantNode && PainlessLookupUtility.isConstantType((Class)irCastNode.getDecorationValue(IRDecorations.IRDExpressionType.class))) {
            ConstantNode irConstantNode = (ConstantNode)irCastNode.getChildNode();
            Object constantValue = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
            constantValue = AnalyzerCaster.constCast(irCastNode.getLocation(), constantValue, (PainlessCast)irCastNode.getDecorationValue(IRDecorations.IRDCast.class));
            irConstantNode.attachDecoration(new IRDecorations.IRDConstant(constantValue));
            irConstantNode.attachDecoration(irCastNode.getDecoration(IRDecorations.IRDExpressionType.class));
            scope.accept(irConstantNode);
        }
    }

    @Override
    public void visitInstanceof(InstanceofNode irInstanceofNode, Consumer<ExpressionNode> scope) {
        irInstanceofNode.getChildNode().visit(this, irInstanceofNode::setChildNode);
    }

    @Override
    public void visitConditional(ConditionalNode irConditionalNode, Consumer<ExpressionNode> scope) {
        irConditionalNode.getConditionNode().visit(this, irConditionalNode::setConditionNode);
        irConditionalNode.getLeftNode().visit(this, irConditionalNode::setLeftNode);
        irConditionalNode.getRightNode().visit(this, irConditionalNode::setRightNode);
    }

    @Override
    public void visitElvis(ElvisNode irElvisNode, Consumer<ExpressionNode> scope) {
        irElvisNode.getLeftNode().visit(this, irElvisNode::setLeftNode);
        irElvisNode.getRightNode().visit(this, irElvisNode::setRightNode);
    }

    @Override
    public void visitListInitialization(ListInitializationNode irListInitializationNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irListInitializationNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irListInitializationNode.getArgumentNodes().get(i).visit(this, e -> irListInitializationNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitMapInitialization(MapInitializationNode irMapInitializationNode, Consumer<ExpressionNode> scope) {
        int j;
        int i;
        for (i = 0; i < irMapInitializationNode.getKeyNodes().size(); ++i) {
            j = i;
            irMapInitializationNode.getKeyNode(i).visit(this, e -> irMapInitializationNode.getKeyNodes().set(j, (ExpressionNode)e));
        }
        for (i = 0; i < irMapInitializationNode.getValueNodes().size(); ++i) {
            j = i;
            irMapInitializationNode.getValueNode(i).visit(this, e -> irMapInitializationNode.getValueNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitNewArray(NewArrayNode irNewArrayNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irNewArrayNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irNewArrayNode.getArgumentNodes().get(i).visit(this, e -> irNewArrayNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitNewObject(NewObjectNode irNewObjectNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irNewObjectNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irNewObjectNode.getArgumentNodes().get(i).visit(this, e -> irNewObjectNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitNullSafeSub(NullSafeSubNode irNullSafeSubNode, Consumer<ExpressionNode> scope) {
        irNullSafeSubNode.getChildNode().visit(this, irNullSafeSubNode::setChildNode);
    }

    @Override
    public void visitStoreVariable(StoreVariableNode irStoreVariableNode, Consumer<ExpressionNode> scope) {
        irStoreVariableNode.getChildNode().visit(this, irStoreVariableNode::setChildNode);
    }

    @Override
    public void visitStoreDotDef(StoreDotDefNode irStoreDotDefNode, Consumer<ExpressionNode> scope) {
        irStoreDotDefNode.getChildNode().visit(this, irStoreDotDefNode::setChildNode);
    }

    @Override
    public void visitStoreDot(StoreDotNode irStoreDotNode, Consumer<ExpressionNode> scope) {
        irStoreDotNode.getChildNode().visit(this, irStoreDotNode::setChildNode);
    }

    @Override
    public void visitStoreDotShortcut(StoreDotShortcutNode irDotSubShortcutNode, Consumer<ExpressionNode> scope) {
        irDotSubShortcutNode.getChildNode().visit(this, irDotSubShortcutNode::setChildNode);
    }

    @Override
    public void visitStoreListShortcut(StoreListShortcutNode irStoreListShortcutNode, Consumer<ExpressionNode> scope) {
        irStoreListShortcutNode.getChildNode().visit(this, irStoreListShortcutNode::setChildNode);
    }

    @Override
    public void visitStoreMapShortcut(StoreMapShortcutNode irStoreMapShortcutNode, Consumer<ExpressionNode> scope) {
        irStoreMapShortcutNode.getChildNode().visit(this, irStoreMapShortcutNode::setChildNode);
    }

    @Override
    public void visitStoreFieldMember(StoreFieldMemberNode irStoreFieldMemberNode, Consumer<ExpressionNode> scope) {
        irStoreFieldMemberNode.getChildNode().visit(this, irStoreFieldMemberNode::setChildNode);
    }

    @Override
    public void visitStoreBraceDef(StoreBraceDefNode irStoreBraceDefNode, Consumer<ExpressionNode> scope) {
        irStoreBraceDefNode.getChildNode().visit(this, irStoreBraceDefNode::setChildNode);
    }

    @Override
    public void visitStoreBrace(StoreBraceNode irStoreBraceNode, Consumer<ExpressionNode> scope) {
        irStoreBraceNode.getChildNode().visit(this, irStoreBraceNode::setChildNode);
    }

    @Override
    public void visitInvokeCallDef(InvokeCallDefNode irInvokeCallDefNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irInvokeCallDefNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irInvokeCallDefNode.getArgumentNodes().get(i).visit(this, e -> irInvokeCallDefNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitInvokeCall(InvokeCallNode irInvokeCallNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irInvokeCallNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irInvokeCallNode.getArgumentNodes().get(i).visit(this, e -> irInvokeCallNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
    }

    @Override
    public void visitInvokeCallMember(InvokeCallMemberNode irInvokeCallMemberNode, Consumer<ExpressionNode> scope) {
        for (int i = 0; i < irInvokeCallMemberNode.getArgumentNodes().size(); ++i) {
            int j = i;
            irInvokeCallMemberNode.getArgumentNodes().get(i).visit(this, e -> irInvokeCallMemberNode.getArgumentNodes().set(j, (ExpressionNode)e));
        }
        PainlessMethod method = (PainlessMethod)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDMethod.class);
        if (method != null && method.annotations.containsKey(CompileTimeOnlyAnnotation.class)) {
            this.replaceCallWithConstant(irInvokeCallMemberNode, scope, method.javaMethod, null);
            return;
        }
        PainlessInstanceBinding instanceBinding = (PainlessInstanceBinding)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDInstanceBinding.class);
        if (instanceBinding != null && instanceBinding.annotations.containsKey(CompileTimeOnlyAnnotation.class)) {
            this.replaceCallWithConstant(irInvokeCallMemberNode, scope, instanceBinding.javaMethod, instanceBinding.targetInstance);
            return;
        }
    }

    private void replaceCallWithConstant(InvokeCallMemberNode irInvokeCallMemberNode, Consumer<ExpressionNode> scope, Method javaMethod, Object receiver) {
        Object result;
        Object[] args = new Object[irInvokeCallMemberNode.getArgumentNodes().size()];
        for (int i = 0; i < irInvokeCallMemberNode.getArgumentNodes().size(); ++i) {
            ExpressionNode argNode = irInvokeCallMemberNode.getArgumentNodes().get(i);
            IRDecorations.IRDConstant constantDecoration = argNode.getDecoration(IRDecorations.IRDConstant.class);
            if (constantDecoration == null) {
                throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("all arguments to [" + javaMethod.getName() + "] must be constant but the [" + (i + 1) + "] argument isn't"));
            }
            args[i] = constantDecoration.getValue();
        }
        try {
            result = javaMethod.invoke(receiver, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("error invoking [" + irInvokeCallMemberNode + "] at compile time", e));
        }
        catch (InvocationTargetException e) {
            throw irInvokeCallMemberNode.getLocation().createError(new IllegalArgumentException("error invoking [" + irInvokeCallMemberNode + "] at compile time", e.getCause()));
        }
        ConstantNode replacement = new ConstantNode(irInvokeCallMemberNode.getLocation());
        replacement.attachDecoration(new IRDecorations.IRDConstant(result));
        replacement.attachDecoration(irInvokeCallMemberNode.getDecoration(IRDecorations.IRDExpressionType.class));
        scope.accept(replacement);
    }

    @Override
    public void visitFlipArrayIndex(FlipArrayIndexNode irFlipArrayIndexNode, Consumer<ExpressionNode> scope) {
        irFlipArrayIndexNode.getChildNode().visit(this, irFlipArrayIndexNode::setChildNode);
    }

    @Override
    public void visitFlipCollectionIndex(FlipCollectionIndexNode irFlipCollectionIndexNode, Consumer<ExpressionNode> scope) {
        irFlipCollectionIndexNode.getChildNode().visit(this, irFlipCollectionIndexNode::setChildNode);
    }

    @Override
    public void visitFlipDefIndex(FlipDefIndexNode irFlipDefIndexNode, Consumer<ExpressionNode> scope) {
        irFlipDefIndexNode.getChildNode().visit(this, irFlipDefIndexNode::setChildNode);
    }

    @Override
    public void visitDup(DupNode irDupNode, Consumer<ExpressionNode> scope) {
        irDupNode.getChildNode().visit(this, irDupNode::setChildNode);
    }
}

