/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyToSequences;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceGroup;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.StageToKeys;
import org.elasticsearch.xpack.eql.execution.sequence.UntilGroup;

public class SequenceMatcher {
    private static final String CB_INFLIGHT_LABEL = "sequence_inflight";
    private static final String CB_COMPLETED_LABEL = "sequence_completed";
    private final Logger log = LogManager.getLogger(SequenceMatcher.class);
    private final KeyToSequences keyToSequences;
    private final StageToKeys stageToKeys;
    private final int numberOfStages;
    private final int completionStage;
    private final Set<Sequence> completed;
    private final long maxSpanInMillis;
    private final boolean descending;
    private final Limit limit;
    private final CircuitBreaker circuitBreaker;
    private final Stats stats = new Stats();
    private boolean headLimit = false;
    private long totalRamBytesUsed = 0L;

    public SequenceMatcher(int stages, boolean descending, TimeValue maxSpan, Limit limit, CircuitBreaker circuitBreaker) {
        this.numberOfStages = stages;
        this.completionStage = stages - 1;
        this.descending = descending;
        this.stageToKeys = new StageToKeys(this.completionStage);
        this.keyToSequences = new KeyToSequences(this.completionStage);
        this.completed = new TreeSet<Sequence>();
        this.maxSpanInMillis = maxSpan.millis();
        this.limit = limit;
        this.circuitBreaker = circuitBreaker;
    }

    private void trackSequence(Sequence sequence) {
        SequenceKey key = sequence.key();
        this.stageToKeys.add(0, key);
        this.keyToSequences.add(0, sequence);
        ++this.stats.seen;
    }

    boolean match(int stage, Iterable<Tuple<KeyAndOrdinal, HitReference>> hits) {
        boolean matched;
        long ramBytesUsedInFlight = this.ramBytesUsedInFlight();
        long ramBytesUsedCompleted = this.ramBytesUsedCompleted();
        for (Tuple<KeyAndOrdinal, HitReference> tuple : hits) {
            KeyAndOrdinal ko = (KeyAndOrdinal)tuple.v1();
            HitReference hit = (HitReference)tuple.v2();
            if (stage == 0) {
                Sequence seq = new Sequence(ko.key, this.numberOfStages, ko.ordinal, hit);
                this.trackSequence(seq);
                continue;
            }
            this.match(stage, ko.key, ko.ordinal, hit);
            if (!this.headLimit) continue;
            this.log.trace("(Head) Limit reached {}", (Object)this.stats);
            return false;
        }
        if (this.tailLimitReached()) {
            this.log.trace("(Tail) Limit reached {}", (Object)this.stats);
            matched = false;
        } else {
            this.log.trace("{}", (Object)this.stats);
            matched = true;
        }
        this.trackMemory(ramBytesUsedInFlight, ramBytesUsedCompleted);
        return matched;
    }

    private boolean tailLimitReached() {
        return this.limit != null && this.limit.limit() < 0 && this.limit.absLimit() <= this.completed.size();
    }

    private void match(int stage, SequenceKey key, Ordinal ordinal, HitReference hit) {
        Ordinal nearestUntil;
        ++this.stats.seen;
        int previousStage = stage - 1;
        SequenceGroup group = this.keyToSequences.groupIfPresent(previousStage, key);
        if (group == null || group.isEmpty()) {
            ++this.stats.ignored;
            return;
        }
        Sequence sequence = (Sequence)group.trimBefore(ordinal);
        if (sequence == null) {
            ++this.stats.ignored;
            return;
        }
        if (group.isEmpty()) {
            this.keyToSequences.remove(previousStage, key);
            this.stageToKeys.remove(previousStage, key);
        }
        if (this.maxSpanInMillis > 0L && ordinal.timestamp() - sequence.startOrdinal().timestamp() > this.maxSpanInMillis) {
            ++this.stats.rejectionMaxspan;
            return;
        }
        UntilGroup until = this.keyToSequences.untilIfPresent(key);
        if (until != null && (nearestUntil = (Ordinal)until.before(ordinal)) != null && nearestUntil.between(sequence.ordinal(), ordinal)) {
            ++this.stats.rejectionUntil;
            return;
        }
        sequence.putMatch(stage, ordinal, hit);
        if (stage == this.completionStage) {
            if (this.descending) {
                for (Sequence seen : this.completed) {
                    if (!seen.key().equals(key) || !seen.ordinal().equals(ordinal)) continue;
                    return;
                }
            }
            this.completed.add(sequence);
            this.headLimit = this.limit != null && this.limit.limit() > 0 && this.completed.size() == this.limit.totalLimit();
        } else {
            this.stageToKeys.add(stage, key);
            this.keyToSequences.add(stage, sequence);
        }
    }

    boolean hasFollowingCandidates(int stage) {
        return this.hasCandidates(stage, this.completionStage);
    }

    boolean hasCandidates() {
        return this.hasCandidates(0, this.completionStage);
    }

    private boolean hasCandidates(int start, int stop) {
        for (int i = start; i < stop; ++i) {
            if (this.stageToKeys.isEmpty(i)) continue;
            return true;
        }
        return false;
    }

    Set<SequenceKey> keys(int stage) {
        return this.stageToKeys.keys(stage);
    }

    Set<SequenceKey> keys() {
        return this.stageToKeys.keys();
    }

    List<Sequence> completed() {
        ArrayList<Sequence> asList = new ArrayList<Sequence>(this.completed);
        return this.limit != null ? this.limit.view(asList) : asList;
    }

    void until(Iterable<KeyAndOrdinal> markers) {
        this.keyToSequences.until(markers);
    }

    void trim(Ordinal ordinal) {
        if (ordinal == null) {
            this.keyToSequences.clear();
        } else {
            this.keyToSequences.trimToTail(ordinal);
        }
    }

    public Stats stats() {
        return this.stats;
    }

    public void clear() {
        this.stats.clear();
        this.keyToSequences.clear();
        this.stageToKeys.clear();
        this.completed.clear();
        this.clearCircuitBreaker();
    }

    private long ramBytesUsedInFlight() {
        return RamUsageEstimator.sizeOf((Accountable)this.keyToSequences) + RamUsageEstimator.sizeOf((Accountable)this.stageToKeys);
    }

    private long ramBytesUsedCompleted() {
        return RamUsageEstimator.sizeOfCollection(this.completed);
    }

    private void addMemory(long bytes, String label) {
        this.totalRamBytesUsed += bytes;
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, label);
    }

    private void clearCircuitBreaker() {
        this.circuitBreaker.addWithoutBreaking(-this.totalRamBytesUsed);
        this.totalRamBytesUsed = 0L;
    }

    private void trackMemory(long prevRamBytesUsedInflight, long prevRamBytesUsedCompleted) {
        long bytesDiff = this.ramBytesUsedInFlight() - prevRamBytesUsedInflight;
        this.addMemory(bytesDiff, CB_INFLIGHT_LABEL);
        bytesDiff = this.ramBytesUsedCompleted() - prevRamBytesUsedCompleted;
        this.addMemory(bytesDiff, CB_COMPLETED_LABEL);
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"Tracking [{}] keys with [{}] completed and {} in-flight", (Object[])new Object[]{this.keyToSequences, this.completed.size(), this.stageToKeys});
    }

    static class Stats {
        long seen = 0L;
        long ignored = 0L;
        long rejectionMaxspan = 0L;
        long rejectionUntil = 0L;

        Stats() {
        }

        public String toString() {
            return LoggerMessageFormat.format(null, (String)"Stats: Seen [{}]/Ignored [{}]/Rejected {Maxspan [{}]/Until [{}]}", (Object[])new Object[]{this.seen, this.ignored, this.rejectionMaxspan, this.rejectionUntil});
        }

        public void clear() {
            this.seen = 0L;
            this.ignored = 0L;
            this.rejectionMaxspan = 0L;
            this.rejectionUntil = 0L;
        }
    }
}

