/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.whitelist;

import java.util.List;
import java.util.Map;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.StartsWithFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.logical.NotProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.CheckNullProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.DefaultBinaryArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.UnaryArithmeticProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexProcessor;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class InternalQlScriptUtils {
    public static <T> Object docValue(Map<String, ScriptDocValues<T>> doc, String fieldName) {
        ScriptDocValues<T> docValues;
        if (doc.containsKey(fieldName) && !(docValues = doc.get(fieldName)).isEmpty()) {
            return docValues.get(0);
        }
        return null;
    }

    public static boolean nullSafeFilter(Boolean filter) {
        return filter == null ? false : filter;
    }

    public static double nullSafeSortNumeric(Number sort) {
        return sort == null ? 0.0 : sort.doubleValue();
    }

    public static String nullSafeSortString(Object sort) {
        return sort == null ? "" : sort.toString();
    }

    public static Number nullSafeCastNumeric(Number number, String typeName) {
        return number == null || Double.isNaN(number.doubleValue()) ? (Number)null : (Number)((Number)DataTypeConverter.convert(number, DataTypes.fromTypeName(typeName)));
    }

    public static Boolean eq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.EQ.apply(left, right);
    }

    public static Boolean nulleq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.NULLEQ.apply(left, right);
    }

    public static Boolean neq(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.NEQ.apply(left, right);
    }

    public static Boolean lt(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.LT.apply(left, right);
    }

    public static Boolean lte(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.LTE.apply(left, right);
    }

    public static Boolean gt(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.GT.apply(left, right);
    }

    public static Boolean gte(Object left, Object right) {
        return BinaryComparisonProcessor.BinaryComparisonOperation.GTE.apply(left, right);
    }

    public static Boolean in(Object value, List<Object> values) {
        return InProcessor.apply(value, values);
    }

    public static Boolean and(Boolean left, Boolean right) {
        return BinaryLogicProcessor.BinaryLogicOperation.AND.apply(left, right);
    }

    public static Boolean or(Boolean left, Boolean right) {
        return BinaryLogicProcessor.BinaryLogicOperation.OR.apply(left, right);
    }

    public static Boolean not(Boolean expression) {
        return NotProcessor.apply(expression);
    }

    public static Boolean isNull(Object expression) {
        return CheckNullProcessor.CheckNullOperation.IS_NULL.apply(expression);
    }

    public static Boolean isNotNull(Object expression) {
        return CheckNullProcessor.CheckNullOperation.IS_NOT_NULL.apply(expression);
    }

    public static Boolean regex(String value, String pattern) {
        return InternalQlScriptUtils.regex(value, pattern, Boolean.FALSE);
    }

    public static Boolean regex(String value, String pattern, Boolean caseInsensitive) {
        return RegexProcessor.RegexOperation.match(value, pattern, caseInsensitive);
    }

    public static Number add(Number left, Number right) {
        return (Number)DefaultBinaryArithmeticOperation.ADD.apply(left, right);
    }

    public static Number div(Number left, Number right) {
        return (Number)DefaultBinaryArithmeticOperation.DIV.apply(left, right);
    }

    public static Number mod(Number left, Number right) {
        return (Number)DefaultBinaryArithmeticOperation.MOD.apply(left, right);
    }

    public static Number mul(Number left, Number right) {
        return (Number)DefaultBinaryArithmeticOperation.MUL.apply(left, right);
    }

    public static Number neg(Number value) {
        return UnaryArithmeticProcessor.UnaryArithmeticOperation.NEGATE.apply(value);
    }

    public static Number sub(Number left, Number right) {
        return (Number)DefaultBinaryArithmeticOperation.SUB.apply(left, right);
    }

    public static Boolean startsWith(String s, String pattern, Boolean caseInsensitive) {
        return (Boolean)StartsWithFunctionProcessor.doProcess(s, pattern, caseInsensitive);
    }
}

