/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.tools.java_version_checker.JavaVersion;

final class SystemJvmOptions {
    SystemJvmOptions() {
    }

    static List<String> systemJvmOptions() {
        return Collections.unmodifiableList(Arrays.asList("-Des.networkaddress.cache.ttl=60", "-Des.networkaddress.cache.negative.ttl=10", "-XX:+AlwaysPreTouch", "-Xss1m", "-Djava.awt.headless=true", "-Dfile.encoding=UTF-8", "-Djna.nosys=true", "-XX:-OmitStackTraceInFastThrow", SystemJvmOptions.maybeShowCodeDetailsInExceptionMessages(), "-Dio.netty.noUnsafe=true", "-Dio.netty.noKeySetOptimization=true", "-Dio.netty.recycler.maxCapacityPerThread=0", "-Dio.netty.allocator.numDirectArenas=0", "-Dlog4j.shutdownHookEnabled=false", "-Dlog4j2.disable.jmx=true", SystemJvmOptions.javaLocaleProviders(), SystemJvmOptions.maybeAddOpensJavaIoToAllUnnamed())).stream().filter(e -> !e.isEmpty()).collect(Collectors.toList());
    }

    private static String maybeShowCodeDetailsInExceptionMessages() {
        if (JavaVersion.majorVersion((List)JavaVersion.CURRENT) >= 14) {
            return "-XX:+ShowCodeDetailsInExceptionMessages";
        }
        return "";
    }

    private static String javaLocaleProviders() {
        if (JavaVersion.majorVersion((List)JavaVersion.CURRENT) == 8) {
            return "-Djava.locale.providers=SPI,JRE";
        }
        return "-Djava.locale.providers=SPI,COMPAT";
    }

    private static String maybeAddOpensJavaIoToAllUnnamed() {
        if (JavaVersion.majorVersion((List)JavaVersion.CURRENT) >= 9) {
            return "--add-opens=java.base/java.io=ALL-UNNAMED";
        }
        return "";
    }
}

