/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class ILMHistoryTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 5;
    public static final String ILM_TEMPLATE_VERSION_VARIABLE = "xpack.ilm_history.template.version";
    public static final String ILM_TEMPLATE_NAME = "ilm-history";
    public static final String ILM_POLICY_NAME = "ilm-history-ilm-policy";
    public static final IndexTemplateConfig TEMPLATE_ILM_HISTORY = new IndexTemplateConfig("ilm-history", "/ilm-history.json", 5, "xpack.ilm_history.template.version");
    public static final LifecyclePolicyConfig ILM_HISTORY_POLICY = new LifecyclePolicyConfig("ilm-history-ilm-policy", "/ilm-history-ilm-policy.json");
    private final boolean ilmHistoryEnabled;

    protected boolean requiresMasterNode() {
        return true;
    }

    public ILMHistoryTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmHistoryEnabled = (Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        if (this.ilmHistoryEnabled) {
            return Collections.singletonList(TEMPLATE_ILM_HISTORY);
        }
        return Collections.emptyList();
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (this.ilmHistoryEnabled) {
            return Collections.singletonList(ILM_HISTORY_POLICY);
        }
        return Collections.emptyList();
    }

    protected String getOrigin() {
        return "index_lifecycle";
    }
}

