/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.ingest.DropProcessor;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.AppendProcessor;
import org.elasticsearch.ingest.common.BytesProcessor;
import org.elasticsearch.ingest.common.CommunityIdProcessor;
import org.elasticsearch.ingest.common.ConvertProcessor;
import org.elasticsearch.ingest.common.CsvProcessor;
import org.elasticsearch.ingest.common.DateIndexNameProcessor;
import org.elasticsearch.ingest.common.DateProcessor;
import org.elasticsearch.ingest.common.DissectProcessor;
import org.elasticsearch.ingest.common.DotExpanderProcessor;
import org.elasticsearch.ingest.common.FailProcessor;
import org.elasticsearch.ingest.common.FingerprintProcessor;
import org.elasticsearch.ingest.common.ForEachProcessor;
import org.elasticsearch.ingest.common.GrokProcessor;
import org.elasticsearch.ingest.common.GrokProcessorGetAction;
import org.elasticsearch.ingest.common.GsubProcessor;
import org.elasticsearch.ingest.common.HtmlStripProcessor;
import org.elasticsearch.ingest.common.JoinProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.KeyValueProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.NetworkDirectionProcessor;
import org.elasticsearch.ingest.common.RegisteredDomainProcessor;
import org.elasticsearch.ingest.common.RemoveProcessor;
import org.elasticsearch.ingest.common.RenameProcessor;
import org.elasticsearch.ingest.common.ScriptProcessor;
import org.elasticsearch.ingest.common.SetProcessor;
import org.elasticsearch.ingest.common.SortProcessor;
import org.elasticsearch.ingest.common.SplitProcessor;
import org.elasticsearch.ingest.common.TrimProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.ingest.common.UriPartsProcessor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class IngestCommonPlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    static final Setting<TimeValue> WATCHDOG_INTERVAL = Setting.timeSetting((String)"ingest.grok.watchdog.interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_MAX_EXECUTION_TIME = Setting.timeSetting((String)"ingest.grok.watchdog.max_execution_time", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return org.elasticsearch.core.Map.ofEntries((Map.Entry[])new Map.Entry[]{org.elasticsearch.core.Map.entry((Object)"date", (Object)new DateProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"set", (Object)new SetProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"append", (Object)new AppendProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"rename", (Object)new RenameProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"remove", (Object)new RemoveProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"split", (Object)new SplitProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"join", (Object)new JoinProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"uppercase", (Object)new UppercaseProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"lowercase", (Object)new LowercaseProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"trim", (Object)new TrimProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"convert", (Object)new ConvertProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"gsub", (Object)new GsubProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"fail", (Object)new FailProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"foreach", (Object)new ForEachProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"date_index_name", (Object)new DateIndexNameProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"sort", (Object)new SortProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"grok", (Object)new GrokProcessor.Factory(Grok.BUILTIN_PATTERNS, IngestCommonPlugin.createGrokThreadWatchdog(parameters))), org.elasticsearch.core.Map.entry((Object)"script", (Object)new ScriptProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"dot_expander", (Object)new DotExpanderProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"json", (Object)new JsonProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"kv", (Object)new KeyValueProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"urldecode", (Object)new URLDecodeProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"bytes", (Object)new BytesProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"pipeline", (Object)new PipelineProcessor.Factory(parameters.ingestService)), org.elasticsearch.core.Map.entry((Object)"dissect", (Object)new DissectProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"drop", (Object)new DropProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"html_strip", (Object)new HtmlStripProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"csv", (Object)new CsvProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"uri_parts", (Object)new UriPartsProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"network_direction", (Object)new NetworkDirectionProcessor.Factory(parameters.scriptService)), org.elasticsearch.core.Map.entry((Object)"community_id", (Object)new CommunityIdProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"fingerprint", (Object)new FingerprintProcessor.Factory()), org.elasticsearch.core.Map.entry((Object)"registered_domain", (Object)new RegisteredDomainProcessor.Factory())});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new GrokProcessorGetAction.RestAction());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(WATCHDOG_INTERVAL, WATCHDOG_MAX_EXECUTION_TIME);
    }

    private static MatcherWatchdog createGrokThreadWatchdog(Processor.Parameters parameters) {
        long intervalMillis = ((TimeValue)WATCHDOG_INTERVAL.get(parameters.env.settings())).getMillis();
        long maxExecutionTimeMillis = ((TimeValue)WATCHDOG_MAX_EXECUTION_TIME.get(parameters.env.settings())).getMillis();
        return MatcherWatchdog.newInstance((long)intervalMillis, (long)maxExecutionTimeMillis, (LongSupplier)parameters.relativeTimeSupplier, parameters.scheduler::apply);
    }
}

