/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.transform.TransformFeatureSetUsage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

public class TransformFeatureSet
implements XPackFeatureSet {
    private final Client client;
    private final ClusterService clusterService;
    private static final Logger logger = LogManager.getLogger(TransformFeatureSet.class);
    private static final String FEATURE_COUNTS = "feature_counts";
    private static final String[] FEATURES = (String[])Stream.concat(Stream.of(TransformConfig.Function.values()).map(TransformConfig.Function::getParseField), Stream.of(TransformField.RETENTION_POLICY, TransformField.SYNC)).map(ParseField::getPreferredName).toArray(String[]::new);
    public static final String[] PROVIDED_STATS = new String[]{TransformIndexerStats.NUM_PAGES.getPreferredName(), TransformIndexerStats.NUM_INPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_OUTPUT_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_DELETED_DOCUMENTS.getPreferredName(), TransformIndexerStats.NUM_INVOCATIONS.getPreferredName(), TransformIndexerStats.INDEX_TIME_IN_MS.getPreferredName(), TransformIndexerStats.SEARCH_TIME_IN_MS.getPreferredName(), TransformIndexerStats.PROCESSING_TIME_IN_MS.getPreferredName(), TransformIndexerStats.DELETE_TIME_IN_MS.getPreferredName(), TransformIndexerStats.INDEX_TOTAL.getPreferredName(), TransformIndexerStats.SEARCH_TOTAL.getPreferredName(), TransformIndexerStats.PROCESSING_TOTAL.getPreferredName(), TransformIndexerStats.INDEX_FAILURES.getPreferredName(), TransformIndexerStats.SEARCH_FAILURES.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName(), TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName()};

    @Inject
    public TransformFeatureSet(ClusterService clusterService, Client client) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    public String name() {
        return "transform";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        PersistentTasksCustomMetadata taskMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)this.clusterService.state());
        List<PersistentTasksCustomMetadata.PersistentTask> transformTasks = taskMetadata == null ? Collections.emptyList() : taskMetadata.findTasks("data_frame/transforms", t -> true);
        int taskCount = transformTasks.size();
        HashMap<String, Long> transformsCountByState = new HashMap<String, Long>();
        for (PersistentTasksCustomMetadata.PersistentTask transformTask : transformTasks) {
            TransformState state = (TransformState)transformTask.getState();
            transformsCountByState.merge(state.getTaskState().value(), 1L, Long::sum);
        }
        SetOnce transformsCountByFeature = new SetOnce();
        ActionListener totalStatsListener = ActionListener.wrap(statSummations -> listener.onResponse((Object)new TransformFeatureSetUsage(transformsCountByState, (Map)transformsCountByFeature.get(), statSummations)), arg_0 -> listener.onFailure(arg_0));
        ActionListener totalTransformCountListener = ActionListener.wrap(transformCountSuccess -> {
            long totalTransforms;
            if (transformCountSuccess.getShardFailures().length > 0) {
                logger.error("total transform count search returned shard failures: {}", (Object)Arrays.toString(transformCountSuccess.getShardFailures()));
            }
            if ((totalTransforms = transformCountSuccess.getHits().getTotalHits().value) == 0L) {
                listener.onResponse((Object)new TransformFeatureSetUsage(transformsCountByState, Collections.emptyMap(), new TransformIndexerStats()));
                return;
            }
            transformsCountByState.merge(TransformTaskState.STOPPED.value(), totalTransforms - (long)taskCount, Long::sum);
            transformsCountByFeature.set(TransformFeatureSet.getFeatureCounts(transformCountSuccess.getAggregations()));
            TransformFeatureSet.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
        }, transformCountFailure -> {
            if (transformCountFailure instanceof ResourceNotFoundException) {
                TransformFeatureSet.getStatisticSummations(this.client, (ActionListener<TransformIndexerStats>)totalStatsListener);
            } else {
                listener.onFailure(transformCountFailure);
            }
        });
        SearchRequest totalTransformCountSearchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*"}).setTrackTotalHits(true).setSize(0).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config")))).addAggregation((AggregationBuilder)AggregationBuilders.filters((String)FEATURE_COUNTS, (FiltersAggregator.KeyedFilter[])((FiltersAggregator.KeyedFilter[])Arrays.stream(FEATURES).map(f -> new FiltersAggregator.KeyedFilter(f, (QueryBuilder)QueryBuilders.existsQuery((String)f))).toArray(FiltersAggregator.KeyedFilter[]::new)))).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)totalTransformCountSearchRequest, (ActionListener)totalTransformCountListener, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    static TransformIndexerStats parseSearchAggs(SearchResponse searchResponse) {
        ArrayList<Double> statisticsList = new ArrayList<Double>(PROVIDED_STATS.length);
        for (String statName : PROVIDED_STATS) {
            Aggregation agg = searchResponse.getAggregations().get(statName);
            if (agg instanceof NumericMetricsAggregation.SingleValue) {
                statisticsList.add(((NumericMetricsAggregation.SingleValue)agg).value());
                continue;
            }
            statisticsList.add(0.0);
        }
        return new TransformIndexerStats(((Double)statisticsList.get(0)).longValue(), ((Double)statisticsList.get(1)).longValue(), ((Double)statisticsList.get(2)).longValue(), ((Double)statisticsList.get(3)).longValue(), ((Double)statisticsList.get(4)).longValue(), ((Double)statisticsList.get(5)).longValue(), ((Double)statisticsList.get(6)).longValue(), ((Double)statisticsList.get(7)).longValue(), ((Double)statisticsList.get(8)).longValue(), ((Double)statisticsList.get(9)).longValue(), ((Double)statisticsList.get(10)).longValue(), ((Double)statisticsList.get(11)).longValue(), ((Double)statisticsList.get(12)).longValue(), ((Double)statisticsList.get(13)).longValue(), ((Double)statisticsList.get(14)).doubleValue(), ((Double)statisticsList.get(15)).doubleValue(), ((Double)statisticsList.get(16)).doubleValue());
    }

    static void getStatisticSummations(Client client, ActionListener<TransformIndexerStats> statsListener) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_state_and_stats")));
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).setSize(0).setQuery((QueryBuilder)queryBuilder);
        String path = TransformField.STATS_FIELD.getPreferredName() + ".";
        for (String statName : PROVIDED_STATS) {
            requestBuilder.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)statName).field(path + statName));
        }
        ActionListener getStatisticSummationsListener = ActionListener.wrap(searchResponse -> {
            if (searchResponse.getShardFailures().length > 0) {
                logger.error("statistics summations search returned shard failures: {}", (Object)Arrays.toString(searchResponse.getShardFailures()));
            }
            statsListener.onResponse((Object)TransformFeatureSet.parseSearchAggs(searchResponse));
        }, failure -> {
            if (failure instanceof ResourceNotFoundException) {
                statsListener.onResponse((Object)new TransformIndexerStats());
            } else {
                statsListener.onFailure(failure);
            }
        });
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)((SearchRequest)requestBuilder.request()), (ActionListener)getStatisticSummationsListener, (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    private static Map<String, Long> getFeatureCounts(Aggregations aggs) {
        Filters filters = (Filters)aggs.get(FEATURE_COUNTS);
        return filters.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount));
    }
}

