/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;

public class TransportGetTransformAction
extends AbstractTransportGetResourcesAction<TransformConfig, GetTransformAction.Request, GetTransformAction.Response> {
    private final ClusterService clusterService;

    @Inject
    public TransportGetTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        this("cluster:monitor/transform/get", transportService, actionFilters, clusterService, client, xContentRegistry);
    }

    protected TransportGetTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super(name, transportService, actionFilters, GetTransformAction.Request::new, client, xContentRegistry);
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, GetTransformAction.Request request, ActionListener<GetTransformAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        TransformNodes.warnIfNoTransformNodes(state);
        this.searchResources((AbstractGetResourcesRequest)request, ActionListener.wrap(r -> listener.onResponse((Object)new GetTransformAction.Response(r.results(), r.count())), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ParseField getResultsField() {
        return TransformField.TRANSFORMS;
    }

    protected String[] getIndices() {
        return new String[]{".transform-internal-*", ".data-frame-internal-*"};
    }

    protected TransformConfig parse(XContentParser parser) {
        return TransformConfig.fromXContent((XContentParser)parser, null, (boolean)true);
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{resourceId}), new Object[0]);
    }

    protected String executionOrigin() {
        return "transform";
    }

    protected String extractIdFromResource(TransformConfig transformConfig) {
        return transformConfig.getId();
    }

    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config");
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.sort("_index", SortOrder.DESC);
    }
}

