/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.notifications;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.notifications.TransformAuditMessage;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;

public class TransformAuditor
extends AbstractAuditor<TransformAuditMessage> {
    private volatile boolean isResetMode = false;

    public TransformAuditor(Client client, String nodeName, ClusterService clusterService) {
        super(new OriginSettingClient(client, "transform"), ".transform-notifications-000002", ".transform-notifications-000002", null, () -> {
            try {
                IndexTemplateMetadata templateMeta = TransformInternalIndex.getAuditIndexTemplateMetadata(clusterService.state().nodes().getMinNodeVersion());
                PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateMeta.name()).patterns(templateMeta.patterns()).version(templateMeta.version()).settings(templateMeta.settings()).mapping((String)((ObjectObjectCursor)templateMeta.mappings().iterator().next()).key, ((CompressedXContent)((ObjectObjectCursor)templateMeta.mappings().iterator().next()).value).uncompressed(), XContentType.JSON);
                for (ObjectObjectCursor cursor : templateMeta.getAliases()) {
                    AliasMetadata meta = (AliasMetadata)cursor.value;
                    Alias alias = new Alias(meta.alias()).indexRouting(meta.indexRouting()).searchRouting(meta.searchRouting()).isHidden(meta.isHidden()).writeIndex(meta.writeIndex());
                    if (meta.filter() != null) {
                        alias.filter(meta.getFilter().string());
                    }
                    request.alias(alias);
                }
                return request;
            }
            catch (IOException e) {
                return null;
            }
        }, () -> null, nodeName, TransformAuditMessage::new, clusterService);
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                this.isResetMode = TransformMetadata.getTransformMetadata((ClusterState)event.state()).isResetMode();
            }
        });
    }

    protected void indexDoc(ToXContent toXContent) {
        if (!this.isResetMode) {
            super.indexDoc(toXContent);
        }
    }

    protected void writeBacklog() {
        if (this.isResetMode) {
            this.clearBacklog();
        } else {
            super.writeBacklog();
        }
    }
}

