/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.common.AbstractCompositeAggFunction;
import org.elasticsearch.xpack.transform.transforms.common.DocumentConversionUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.AggregationResultUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.CompositeBucketsChangeCollector;
import org.elasticsearch.xpack.transform.transforms.pivot.GroupByOptimizer;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.transforms.pivot.TransformAggregations;

public class Pivot
extends AbstractCompositeAggFunction {
    private static final Logger logger = LogManager.getLogger(Pivot.class);
    private final PivotConfig config;
    private final SettingsConfig settings;
    private final Version version;

    public Pivot(PivotConfig config, SettingsConfig settings, Version version, Set<String> runtimeFields) {
        super(Pivot.createCompositeAggregation(config, runtimeFields));
        this.config = config;
        this.settings = settings;
        this.version = version == null ? Version.CURRENT : version;
    }

    @Override
    public void validateConfig(ActionListener<Boolean> listener) {
        for (AggregationBuilder agg : this.config.getAggregationConfig().getAggregatorFactories()) {
            if (TransformAggregations.isSupportedByTransform(agg.getType())) continue;
            listener.onFailure((Exception)new ValidationException().addValidationError(new ParameterizedMessage("Unsupported aggregation type [{}]", (Object)agg.getType()).getFormattedMessage()));
            return;
        }
        listener.onResponse((Object)true);
    }

    @Override
    public List<String> getPerformanceCriticalFields() {
        return this.config.getGroupConfig().getGroups().values().stream().map(SingleGroupSource::getField).collect(Collectors.toList());
    }

    @Override
    public void deduceMappings(Client client, SourceConfig sourceConfig, ActionListener<Map<String, String>> listener) {
        SchemaUtil.deduceMappings(client, this.config, sourceConfig.getIndex(), sourceConfig.getRuntimeMappings(), listener);
    }

    @Override
    public int getInitialPageSize() {
        return this.config.getMaxPageSearchSize() == null ? Transform.DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE : this.config.getMaxPageSearchSize();
    }

    @Override
    public Function.ChangeCollector buildChangeCollector(String synchronizationField) {
        return CompositeBucketsChangeCollector.buildChangeCollector(this.config.getGroupConfig().getGroups(), synchronizationField);
    }

    @Override
    protected Map<String, Object> documentTransformationFunction(Map<String, Object> document) {
        return DocumentConversionUtils.removeInternalFields(document);
    }

    @Override
    protected Stream<Map<String, Object>> extractResults(CompositeAggregation agg, Map<String, String> fieldTypeMap, TransformIndexerStats transformIndexerStats, TransformProgress transformProgress) {
        boolean datesAsEpoch = this.settings.getDatesAsEpochMillis() != null ? this.settings.getDatesAsEpochMillis() : !this.version.onOrAfter(Version.V_7_11_0);
        return AggregationResultUtils.extractCompositeAggregationResults(agg, this.config.getGroupConfig(), this.config.getAggregationConfig().getAggregatorFactories(), this.config.getAggregationConfig().getPipelineAggregatorFactories(), fieldTypeMap, transformIndexerStats, transformProgress, datesAsEpoch);
    }

    @Override
    public SearchSourceBuilder buildSearchQueryForInitialProgress(SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder existsClauses = QueryBuilders.boolQuery();
        this.config.getGroupConfig().getGroups().values().forEach(src -> {
            if (!src.getMissingBucket() && src.getField() != null) {
                existsClauses.must((QueryBuilder)QueryBuilders.existsQuery((String)src.getField()));
            }
        });
        return searchSourceBuilder.query((QueryBuilder)existsClauses).size(0).trackTotalHits(true);
    }

    private static CompositeAggregationBuilder createCompositeAggregation(PivotConfig config, Set<String> runtimeFields) {
        CompositeAggregationBuilder compositeAggregation = Pivot.createCompositeAggregationSources(config, runtimeFields);
        config.getAggregationConfig().getAggregatorFactories().forEach(arg_0 -> ((CompositeAggregationBuilder)compositeAggregation).subAggregation(arg_0));
        config.getAggregationConfig().getPipelineAggregatorFactories().forEach(arg_0 -> ((CompositeAggregationBuilder)compositeAggregation).subAggregation(arg_0));
        return compositeAggregation;
    }

    private static CompositeAggregationBuilder createCompositeAggregationSources(PivotConfig config, Set<String> runtimeFields) {
        CompositeAggregationBuilder compositeAggregation;
        Collection<Map.Entry<String, SingleGroupSource>> groups = GroupByOptimizer.reorderGroups(config.getGroupConfig().getGroups(), runtimeFields);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field(CompositeAggregationBuilder.SOURCES_FIELD_NAME.getPreferredName());
            builder.startArray();
            for (Map.Entry<String, SingleGroupSource> groupBy : groups) {
                builder.startObject();
                builder.startObject(groupBy.getKey());
                builder.field(groupBy.getValue().getType().value(), (ToXContent)groupBy.getValue());
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            XContentParser parser = builder.generator().contentType().xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
            compositeAggregation = (CompositeAggregationBuilder)CompositeAggregationBuilder.PARSER.parse(parser, (Object)"_transform");
        }
        catch (IOException e) {
            throw new RuntimeException(TransformMessages.getMessage((String)"Failed to create composite aggregation from {0} function", (Object[])new Object[]{"pivot"}), e);
        }
        return compositeAggregation;
    }
}

