/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginsService;

class RemovePluginAction {
    static final int PLUGIN_STILL_USED = 11;
    private final Terminal terminal;
    private final Environment env;
    private final boolean purge;

    RemovePluginAction(Terminal terminal, Environment env, boolean purge) {
        this.terminal = terminal;
        this.env = env;
        this.purge = purge;
    }

    void execute(List<PluginDescriptor> plugins) throws IOException, UserException {
        if (plugins == null || plugins.isEmpty()) {
            throw new UserException(64, "At least one plugin ID is required");
        }
        this.ensurePluginsNotUsedByOtherPlugins(plugins);
        for (PluginDescriptor plugin : plugins) {
            this.checkCanRemove(plugin);
        }
        for (PluginDescriptor plugin : plugins) {
            this.removePlugin(plugin);
        }
    }

    private void ensurePluginsNotUsedByOtherPlugins(List<PluginDescriptor> plugins) throws IOException, UserException {
        HashMap<String, List> usedBy = new HashMap<String, List>();
        Set bundles = PluginsService.getPluginBundles((Path)this.env.pluginsFile());
        for (PluginsService.Bundle bundle : bundles) {
            for (String extendedPlugin : bundle.plugin.getExtendedPlugins()) {
                for (PluginDescriptor plugin : plugins) {
                    String pluginId = plugin.getId();
                    if (!extendedPlugin.equals(pluginId)) continue;
                    usedBy.computeIfAbsent(bundle.plugin.getName(), _key -> new ArrayList()).add(pluginId);
                }
            }
        }
        if (usedBy.isEmpty()) {
            return;
        }
        StringJoiner message = new StringJoiner("\n");
        message.add("Cannot remove plugins because the following are extended by other plugins:");
        usedBy.forEach((key, value) -> {
            String s = "\t" + key + " used by " + value;
            message.add(s);
        });
        throw new UserException(11, message.toString());
    }

    private void checkCanRemove(PluginDescriptor plugin) throws UserException {
        String pluginId = plugin.getId();
        Path pluginDir = this.env.pluginsFile().resolve(pluginId);
        Path pluginConfigDir = this.env.configFile().resolve(pluginId);
        Path removing = this.env.pluginsFile().resolve(".removing-" + pluginId);
        if (!Files.exists(pluginDir, new LinkOption[0]) && !Files.exists(pluginConfigDir, new LinkOption[0]) && !Files.exists(removing, new LinkOption[0]) || !Files.exists(pluginDir, new LinkOption[0]) && Files.exists(pluginConfigDir, new LinkOption[0]) && !this.purge) {
            String message = String.format(Locale.ROOT, "plugin [%s] not found; run 'elasticsearch-plugin list' to get list of installed plugins", pluginId);
            throw new UserException(78, message);
        }
        Path pluginBinDir = this.env.binFile().resolve(pluginId);
        if (Files.exists(pluginBinDir, new LinkOption[0]) && !Files.isDirectory(pluginBinDir, new LinkOption[0])) {
            throw new UserException(74, "bin dir for " + pluginId + " is not a directory");
        }
    }

    private void removePlugin(PluginDescriptor plugin) throws IOException {
        Stream<Path> paths;
        Path pluginBinDir;
        String pluginId = plugin.getId();
        Path pluginDir = this.env.pluginsFile().resolve(pluginId);
        Path pluginConfigDir = this.env.configFile().resolve(pluginId);
        Path removing = this.env.pluginsFile().resolve(".removing-" + pluginId);
        this.terminal.println("-> removing [" + pluginId + "]...");
        ArrayList<Path> pluginPaths = new ArrayList<Path>();
        if (Files.exists(pluginDir, new LinkOption[0])) {
            try (Stream<Path> paths2 = Files.list(pluginDir);){
                pluginPaths.addAll(paths2.collect(Collectors.toList()));
            }
            this.terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginDir + "]");
        }
        if (Files.exists(pluginBinDir = this.env.binFile().resolve(pluginId), new LinkOption[0])) {
            paths = Files.list(pluginBinDir);
            try {
                pluginPaths.addAll(paths.collect(Collectors.toList()));
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
            pluginPaths.add(pluginBinDir);
            this.terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginBinDir + "]");
        }
        if (Files.exists(pluginConfigDir, new LinkOption[0])) {
            if (this.purge) {
                paths = Files.list(pluginConfigDir);
                try {
                    pluginPaths.addAll(paths.collect(Collectors.toList()));
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
                pluginPaths.add(pluginConfigDir);
                this.terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginConfigDir + "]");
            } else {
                String message = String.format(Locale.ROOT, "-> preserving plugin config files [%s] in case of upgrade; use --purge if not needed", pluginConfigDir);
                this.terminal.println(message);
            }
        }
        try {
            Files.createFile(removing, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            this.terminal.println(Terminal.Verbosity.VERBOSE, "marker file [" + removing + "] already exists");
        }
        pluginPaths.add(pluginDir);
        pluginPaths.add(removing);
        IOUtils.rm((Path[])pluginPaths.toArray(new Path[0]));
    }
}

