/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregationBuilder;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregator;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregatorSupplier;

public class BoxplotAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double compression;
    private final BoxplotAggregatorSupplier aggregatorSupplier;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(BoxplotAggregationBuilder.REGISTRY_KEY, Arrays.asList(new ValuesSourceType[]{CoreValuesSourceType.NUMERIC, AnalyticsValuesSourceType.HISTOGRAM}), BoxplotAggregator::new, true);
    }

    BoxplotAggregatorFactory(String name, ValuesSourceConfig config, double compression, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, BoxplotAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.compression = compression;
        this.aggregatorSupplier = aggregatorSupplier;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new BoxplotAggregator(this.name, null, this.config.format(), this.compression, this.context, parent, metadata);
    }

    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config.getValuesSource(), this.config.format(), this.compression, this.context, parent, metadata);
    }
}

