/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.geo.GeoPlugin;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.spatial.action.SpatialStatsAction;
import org.elasticsearch.xpack.spatial.GeometryFormatterExtension;
import org.elasticsearch.xpack.spatial.SpatialFeatureSet;
import org.elasticsearch.xpack.spatial.SpatialUsage;
import org.elasticsearch.xpack.spatial.action.SpatialStatsTransportAction;
import org.elasticsearch.xpack.spatial.index.mapper.GeoShapeWithDocValuesFieldMapper;
import org.elasticsearch.xpack.spatial.index.mapper.PointFieldMapper;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeFieldMapper;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryBuilder;
import org.elasticsearch.xpack.spatial.ingest.CircleProcessor;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregationBuilder;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.AbstractGeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.AbstractGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.BoundedGeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.BoundedGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellIdSource;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeHashGridAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeTileGridAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.UnboundedGeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.UnboundedGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.GeoShapeBoundsAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.GeoShapeCentroidAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class SpatialPlugin
extends GeoPlugin
implements MapperPlugin,
ActionPlugin,
SearchPlugin,
IngestPlugin,
ExtensiblePlugin {
    private final SpatialUsage usage = new SpatialUsage();
    private final SetOnce<GeoFormatterFactory<Geometry>> geoFormatterFactory = new SetOnce();

    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(b -> XPackPlugin.bindFeatureSet((Binder)b, SpatialFeatureSet.class));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.singletonList(new ActionPlugin.ActionHandler((ActionType)SpatialStatsAction.INSTANCE, SpatialStatsTransportAction.class, new Class[0]));
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        HashMap<String, Object> mappers = new HashMap<String, Object>(super.getMappers());
        mappers.put("shape", ShapeFieldMapper.PARSER);
        mappers.put("point", PointFieldMapper.PARSER);
        mappers.put("geo_shape", new GeoShapeWithDocValuesFieldMapper.TypeParser((GeoFormatterFactory<Geometry>)((GeoFormatterFactory)this.geoFormatterFactory.get())));
        return Collections.unmodifiableMap(mappers);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("shape", ShapeQueryBuilder::new, ShapeQueryBuilder::fromXContent));
    }

    public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return org.elasticsearch.core.List.of((Object[])new Consumer[]{this::registerGeoShapeCentroidAggregator, this::registerGeoShapeGridAggregators, SpatialPlugin::registerGeoShapeBoundsAggregator, SpatialPlugin::registerValueCountAggregator, SpatialPlugin::registerCardinalityAggregator});
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return Collections.singletonList(new SearchPlugin.AggregationSpec("geo_line", GeoLineAggregationBuilder::new, this.usage.track(SpatialStatsAction.Item.GEOLINE, this.checkLicense((ContextParser)GeoLineAggregationBuilder.PARSER, XPackLicenseState.Feature.SPATIAL_GEO_LINE))).addResultReader(InternalGeoLine::new).setAggregatorRegistrar(GeoLineAggregationBuilder::registerUsage));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Collections.singletonMap("circle", new CircleProcessor.Factory());
    }

    private static void registerGeoShapeBoundsAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoBoundsAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), GeoShapeBoundsAggregator::new, true);
    }

    private void registerGeoShapeCentroidAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoCentroidAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, valuesSourceConfig, context, parent, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_CENTROID)) {
                return new GeoShapeCentroidAggregator(name, context, parent, valuesSourceConfig, metadata);
            }
            throw LicenseUtils.newComplianceException((String)"geo_centroid aggregation on geo_shape fields");
        }, true);
    }

    private void registerGeoShapeGridAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoHashGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_GRID)) {
                AbstractGeoHashGridTiler tiler = geoBoundingBox.isUnbounded() ? new UnboundedGeoHashGridTiler(precision) : new BoundedGeoHashGridTiler(precision, geoBoundingBox);
                GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((GeoShapeValuesSource)valuesSource, tiler);
                GeoShapeHashGridAggregator agg = new GeoShapeHashGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata);
                cellIdSource.setCircuitBreakerConsumer(agg::addRequestBytes);
                return agg;
            }
            throw LicenseUtils.newComplianceException((String)"geohash_grid aggregation on geo_shape fields");
        }, true);
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata) -> {
            if (this.getLicenseState().checkFeature(XPackLicenseState.Feature.SPATIAL_GEO_GRID)) {
                AbstractGeoTileGridTiler tiler = geoBoundingBox.isUnbounded() ? new UnboundedGeoTileGridTiler(precision) : new BoundedGeoTileGridTiler(precision, geoBoundingBox);
                GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((GeoShapeValuesSource)valuesSource, tiler);
                GeoShapeTileGridAggregator agg = new GeoShapeTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, collectsFromSingleBucket, metadata);
                cellIdSource.setCircuitBreakerConsumer(agg::addRequestBytes);
                return agg;
            }
            throw LicenseUtils.newComplianceException((String)"geotile_grid aggregation on geo_shape fields");
        }, true);
    }

    private static void registerValueCountAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(ValueCountAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), ValueCountAggregator::new, true);
    }

    private static void registerCardinalityAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoShapeValuesSourceType.instance(), CardinalityAggregator::new, true);
    }

    private <T> ContextParser<String, T> checkLicense(ContextParser<String, T> realParser, XPackLicenseState.Feature feature) {
        return (parser, name) -> {
            if (!this.getLicenseState().checkFeature(feature)) {
                throw LicenseUtils.newComplianceException((String)feature.name());
            }
            return realParser.parse(parser, name);
        };
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        ArrayList formatterFactories = new ArrayList();
        loader.loadExtensions(GeometryFormatterExtension.class).stream().map(GeometryFormatterExtension::getGeometryFormatterFactories).forEach(formatterFactories::addAll);
        this.geoFormatterFactory.set((Object)new GeoFormatterFactory(formatterFactories));
    }
}

