/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.Extent;
import org.elasticsearch.xpack.spatial.index.fielddata.TriangleTreeReader;

public class GeometryDocValueReader {
    private final ByteArrayDataInput input;
    private final Extent extent = new Extent();
    private int treeOffset;
    private int docValueOffset;

    public GeometryDocValueReader() {
        this.input = new ByteArrayDataInput();
    }

    public void reset(BytesRef bytesRef) {
        this.input.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        this.docValueOffset = bytesRef.offset;
        this.treeOffset = 0;
    }

    protected Extent getExtent() {
        if (this.treeOffset == 0) {
            this.getSumCentroidWeight();
            Extent.readFromCompressed(this.input, this.extent);
            this.treeOffset = this.input.getPosition();
        } else {
            this.input.setPosition(this.treeOffset);
        }
        return this.extent;
    }

    protected int getCentroidX() {
        this.input.setPosition(this.docValueOffset + 0);
        return this.input.readInt();
    }

    protected int getCentroidY() {
        this.input.setPosition(this.docValueOffset + 4);
        return this.input.readInt();
    }

    protected DimensionalShapeType getDimensionalShapeType() {
        this.input.setPosition(this.docValueOffset + 8);
        return DimensionalShapeType.readFrom(this.input);
    }

    protected double getSumCentroidWeight() {
        this.input.setPosition(this.docValueOffset + 9);
        return Double.longBitsToDouble(this.input.readVLong());
    }

    public void visit(TriangleTreeReader.Visitor visitor) {
        Extent extent = this.getExtent();
        int thisMaxX = extent.maxX();
        int thisMinX = extent.minX();
        int thisMaxY = extent.maxY();
        int thisMinY = extent.minY();
        if (visitor.push(thisMinX, thisMinY, thisMaxX, thisMaxY)) {
            TriangleTreeReader.visit(this.input, visitor, thisMaxX, thisMaxY);
        }
    }
}

