/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RebuildTask
extends Task {
    static final String REBUILD_TASK_CLASS = "com.unboundid.directory.server.tasks.RebuildTask";
    private static final String ATTR_BASE_DN = "ds-task-rebuild-base-dn";
    private static final String ATTR_INDEX = "ds-task-rebuild-index";
    private static final String ATTR_MAX_THREADS = "ds-task-rebuild-max-threads";
    private static final String OC_REBUILD_TASK = "ds-task-rebuild";
    private static final TaskProperty PROPERTY_BASE_DN = new TaskProperty("ds-task-rebuild-base-dn", TaskMessages.INFO_DISPLAY_NAME_BASE_DN_REBUILD.get(), TaskMessages.INFO_DESCRIPTION_BASE_DN_REBUILD.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_INDEX = new TaskProperty("ds-task-rebuild-index", TaskMessages.INFO_DISPLAY_NAME_INDEX_REBUILD.get(), TaskMessages.INFO_DESCRIPTION_INDEX_REBUILD.get(), String.class, true, true, false);
    private static final TaskProperty PROPERTY_MAX_THREADS = new TaskProperty("ds-task-rebuild-max-threads", TaskMessages.INFO_DISPLAY_NAME_MAX_THREADS_REBUILD.get(), TaskMessages.INFO_DESCRIPTION_MAX_THREADS_REBUILD.get(), Long.class, false, false, true);
    private static final long serialVersionUID = 6015907901926792443L;
    private final int maxThreads;
    private final String baseDN;
    private final List<String> indexes;

    public RebuildTask() {
        this.baseDN = null;
        this.maxThreads = -1;
        this.indexes = null;
    }

    public RebuildTask(String taskID, String baseDN, List<String> indexes) {
        this(taskID, baseDN, indexes, -1, null, null, null, null, null);
    }

    public RebuildTask(String taskID, String baseDN, List<String> indexes, int maxThreads, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, baseDN, indexes, maxThreads, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public RebuildTask(String taskID, String baseDN, List<String> indexes, int maxThreads, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, REBUILD_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(baseDN, indexes);
        Validator.ensureFalse(indexes.isEmpty(), "RebuildTask.indexes must not be empty.");
        this.baseDN = baseDN;
        this.indexes = Collections.unmodifiableList(indexes);
        this.maxThreads = maxThreads;
    }

    public RebuildTask(Entry entry) throws TaskException {
        super(entry);
        this.baseDN = entry.getAttributeValue(ATTR_BASE_DN);
        if (this.baseDN == null) {
            throw new TaskException(TaskMessages.ERR_REBUILD_TASK_NO_BASE_DN.get(this.getTaskEntryDN()));
        }
        String[] indexArray = entry.getAttributeValues(ATTR_INDEX);
        if (indexArray == null || indexArray.length == 0) {
            throw new TaskException(TaskMessages.ERR_REBUILD_TASK_NO_INDEXES.get(this.getTaskEntryDN()));
        }
        this.indexes = Collections.unmodifiableList(Arrays.asList(indexArray));
        String threadsStr = entry.getAttributeValue(ATTR_MAX_THREADS);
        if (threadsStr == null) {
            this.maxThreads = -1;
        } else {
            try {
                this.maxThreads = Integer.parseInt(threadsStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_REBUILD_TASK_INVALID_MAX_THREADS.get(this.getTaskEntryDN(), threadsStr), e);
            }
        }
    }

    public RebuildTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(REBUILD_TASK_CLASS, properties);
        long t = -1L;
        String b = null;
        String[] i = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BASE_DN)) {
                b = RebuildTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INDEX)) {
                i = RebuildTask.parseStrings(p, values, i);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_MAX_THREADS)) continue;
            t = RebuildTask.parseLong(p, values, t);
        }
        if (b == null) {
            throw new TaskException(TaskMessages.ERR_REBUILD_TASK_NO_BASE_DN.get(this.getTaskEntryDN()));
        }
        if (i == null) {
            throw new TaskException(TaskMessages.ERR_REBUILD_TASK_NO_INDEXES.get(this.getTaskEntryDN()));
        }
        this.baseDN = b;
        this.indexes = Collections.unmodifiableList(Arrays.asList(i));
        this.maxThreads = (int)t;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_REBUILD.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_REBUILD.get();
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public List<String> getIndexNames() {
        return this.indexes;
    }

    public int getMaxRebuildThreads() {
        return this.maxThreads;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_REBUILD_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(3);
        attrs.add(new Attribute(ATTR_BASE_DN, this.baseDN));
        attrs.add(new Attribute(ATTR_INDEX, this.indexes));
        if (this.maxThreads > 0) {
            attrs.add(new Attribute(ATTR_MAX_THREADS, String.valueOf(this.maxThreads)));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BASE_DN, PROPERTY_INDEX, PROPERTY_MAX_THREADS);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(10);
        props.put(PROPERTY_BASE_DN, Collections.singletonList(this.baseDN));
        props.put(PROPERTY_INDEX, Collections.unmodifiableList(this.indexes));
        props.put(PROPERTY_MAX_THREADS, Collections.singletonList(Long.valueOf(this.maxThreads)));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

