/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.core.internal.io.IOUtils;

public class Streams {
    private static final ThreadLocal<byte[]> buffer = ThreadLocal.withInitial(() -> new byte[8192]);

    private Streams() {
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer, boolean close) throws IOException {
        long l;
        block6: {
            Exception err = null;
            try {
                int bytesRead;
                long byteCount = 0L;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    byteCount += (long)bytesRead;
                }
                out.flush();
                l = byteCount;
                if (!close) break block6;
            }
            catch (IOException | RuntimeException e) {
                try {
                    err = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (close) {
                        IOUtils.close(err, in, out);
                    }
                    throw throwable;
                }
            }
            IOUtils.close(err, in, out);
        }
        return l;
    }

    public static long copy(InputStream in, OutputStream out, boolean close) throws IOException {
        return Streams.copy(in, out, buffer.get(), close);
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        return Streams.copy(in, out, buffer, true);
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, buffer.get(), true);
    }
}

