/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.core.internal.net.NetUtils;
import org.elasticsearch.http.AbstractHttpServerTransport;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpReadTimeoutException;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpPipeliningHandler;
import org.elasticsearch.http.netty4.Netty4HttpRequestCreator;
import org.elasticsearch.http.netty4.Netty4HttpRequestHandler;
import org.elasticsearch.http.netty4.Netty4HttpResponseCreator;
import org.elasticsearch.http.netty4.Netty4HttpServerChannel;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NettyAllocator;
import org.elasticsearch.transport.NettyByteBufSizer;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4HttpServerTransport.class);
    private static final ByteSizeValue MTU = new ByteSizeValue(Long.parseLong(System.getProperty("es.net.mtu", "1500")));
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting<Integer>("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get((Settings)s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt(s, 2, Integer.MAX_VALUE, SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = Setting.intSetting("http.netty.worker_count", 0, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("http.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    private final ByteSizeValue maxInitialLineLength;
    private final ByteSizeValue maxHeaderSize;
    private final ByteSizeValue maxChunkSize;
    private final int pipeliningMaxEvents;
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private volatile ServerBootstrap serverBootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    static final AttributeKey<Netty4HttpChannel> HTTP_CHANNEL_KEY = AttributeKey.newInstance("es-http-channel");
    static final AttributeKey<Netty4HttpServerChannel> HTTP_SERVER_CHANNEL_KEY = AttributeKey.newInstance("es-http-server-channel");

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings);
        Netty4Utils.setAvailableProcessors(EsExecutors.NODE_PROCESSORS_SETTING.get(settings));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.maxChunkSize = HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.pipeliningMaxEvents = HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.maxCompositeBufferComponents = SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.readTimeoutMillis = Math.toIntExact(HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings).getMillis());
        ByteSizeValue receivePredictor = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            ByteSizeValue tcpSendBufferSize;
            this.sharedGroup = this.sharedGroupFactory.getHttpGroup();
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group(this.sharedGroup.getLowLevelGroup());
            this.serverBootstrap.channel(NettyAllocator.getServerChannelType());
            this.serverBootstrap.option(ChannelOption.ALLOCATOR, NettyAllocator.getAllocator());
            this.serverBootstrap.childOption(ChannelOption.ALLOCATOR, NettyAllocator.getAllocator());
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.handler(new ServerChannelExceptionHandler(this));
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings));
            if (HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
                SocketOption<Integer> keepCountOption;
                SocketOption<Integer> keepIntervalOption;
                SocketOption<Integer> keepIdleOption;
                if (HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of(keepIdleOption), HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings));
                }
                if (HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of(keepIntervalOption), HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings));
                }
                if (HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of(keepCountOption), HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings));
                }
            }
            if ((tcpSendBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
            boolean reuseAddress = HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, reuseAddress);
            this.bindServer();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    @Override
    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        ChannelFuture future = this.serverBootstrap.bind(socketAddress).sync();
        Channel channel = future.channel();
        Netty4HttpServerChannel httpServerChannel = new Netty4HttpServerChannel(channel);
        channel.attr(HTTP_SERVER_CHANNEL_KEY).set(httpServerChannel);
        return httpServerChannel;
    }

    @Override
    protected void stopInternal() {
        if (this.sharedGroup != null) {
            this.sharedGroup.shutdown();
            this.sharedGroup = null;
        }
    }

    @Override
    public void onException(HttpChannel channel, Exception cause) {
        if (cause instanceof ReadTimeoutException) {
            super.onException(channel, new HttpReadTimeoutException(this.readTimeoutMillis, cause));
        } else {
            super.onException(channel, cause);
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.handlingSettings);
    }

    @ChannelHandler.Sharable
    private static class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final Netty4HttpServerTransport transport;

        private ServerChannelExceptionHandler(Netty4HttpServerTransport transport) {
            this.transport = transport;
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            Netty4HttpServerChannel httpServerChannel = ctx.channel().attr(HTTP_SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                this.transport.onServerException(httpServerChannel, new Exception(cause));
            } else {
                this.transport.onServerException(httpServerChannel, (Exception)cause);
            }
        }
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final Netty4HttpRequestCreator requestCreator;
        private final Netty4HttpRequestHandler requestHandler;
        private final Netty4HttpResponseCreator responseCreator;
        private final HttpHandlingSettings handlingSettings;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            this.transport = transport;
            this.handlingSettings = handlingSettings;
            this.requestCreator = new Netty4HttpRequestCreator();
            this.requestHandler = new Netty4HttpRequestHandler(transport);
            this.responseCreator = new Netty4HttpResponseCreator();
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel(ch);
            ch.attr(HTTP_CHANNEL_KEY).set(nettyHttpChannel);
            ch.pipeline().addLast("byte_buf_sizer", (ChannelHandler)NettyByteBufSizer.INSTANCE);
            ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler(this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            HttpRequestDecoder decoder = new HttpRequestDecoder(this.handlingSettings.getMaxInitialLineLength(), this.handlingSettings.getMaxHeaderSize(), this.handlingSettings.getMaxChunkSize());
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            ch.pipeline().addLast("decoder", (ChannelHandler)decoder);
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(this.handlingSettings.getMaxContentLength());
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            ch.pipeline().addLast("aggregator", (ChannelHandler)aggregator);
            if (this.handlingSettings.isCompression()) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.handlingSettings.getCompressionLevel()));
            }
            ch.pipeline().addLast("request_creator", (ChannelHandler)this.requestCreator);
            ch.pipeline().addLast("response_creator", (ChannelHandler)this.responseCreator);
            ch.pipeline().addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, this.transport.pipeliningMaxEvents));
            ch.pipeline().addLast("handler", (ChannelHandler)this.requestHandler);
            this.transport.serverAcceptedChannel(nettyHttpChannel);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

