/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.http.nio.NettyListener;
import org.elasticsearch.http.nio.PagedByteBuf;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.Page;
import org.elasticsearch.nio.WriteOperation;

class NettyAdaptor {
    private final EmbeddedChannel nettyChannel;
    private final LinkedList<FlushOperation> flushOperations = new LinkedList();

    NettyAdaptor(ChannelHandler ... handlers) {
        this.nettyChannel = new EmbeddedChannel();
        this.nettyChannel.pipeline().addLast("write_captor", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                try {
                    ByteBuf message = (ByteBuf)msg;
                    promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> message.release()));
                    NettyListener listener = NettyListener.fromChannelPromise(promise);
                    NettyAdaptor.this.flushOperations.add(new FlushOperation(message.nioBuffers(), listener));
                }
                catch (Exception e) {
                    promise.setFailure(e);
                }
            }
        });
        this.nettyChannel.pipeline().addLast(handlers);
    }

    public void close() throws Exception {
        assert (this.flushOperations.isEmpty()) : "Should close outbound operations before calling close";
        ChannelFuture closeFuture = this.nettyChannel.close();
        closeFuture.await();
        if (!closeFuture.isSuccess()) {
            Throwable cause = closeFuture.cause();
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            throw (Exception)cause;
        }
    }

    public void addCloseListener(BiConsumer<Void, Exception> listener) {
        this.nettyChannel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                listener.accept(null, null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                assert (cause instanceof Exception);
                listener.accept(null, (Exception)cause);
            }
        }));
    }

    public int read(ByteBuffer[] buffers) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(buffers);
        int initialReaderIndex = byteBuf.readerIndex();
        this.nettyChannel.writeInbound(byteBuf);
        return byteBuf.readerIndex() - initialReaderIndex;
    }

    public int read(Page[] pages) {
        ByteBuf byteBuf = PagedByteBuf.byteBufFromPages(pages);
        int readableBytes = byteBuf.readableBytes();
        this.nettyChannel.writeInbound(byteBuf);
        return readableBytes;
    }

    public Object pollInboundMessage() {
        return this.nettyChannel.readInbound();
    }

    public void write(WriteOperation writeOperation) {
        this.nettyChannel.writeAndFlush(writeOperation.getObject(), NettyListener.fromBiConsumer(writeOperation.getListener(), this.nettyChannel));
    }

    public FlushOperation pollOutboundOperation() {
        return this.flushOperations.pollFirst();
    }

    public int getOutboundCount() {
        return this.flushOperations.size();
    }
}

