/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.net.InetAddress;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fielddata.IpScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.IpFieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.IpScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.IpScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.IpScriptFieldTermQuery;
import org.elasticsearch.search.runtime.IpScriptFieldTermsQuery;

public final class IpScriptFieldType
extends AbstractScriptFieldType<IpFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<IpFieldScript.Factory>(name, IpFieldScript.CONTEXT){

        @Override
        AbstractScriptFieldType<?> createFieldType(String name, IpFieldScript.Factory factory, Script script, Map<String, String> meta) {
            return new IpScriptFieldType(name, factory, this.getScript(), this.meta());
        }

        @Override
        IpFieldScript.Factory getParseFromSourceFactory() {
            return IpFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        IpFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return IpFieldScript.leafAdapter(parentScriptFactory);
        }
    });

    IpScriptFieldType(String name, IpFieldScript.Factory scriptFactory, Script script, Map<String, String> meta) {
        super(name, (SearchLookup searchLookup) -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup), script, meta);
    }

    @Override
    public String typeName() {
        return "ip";
    }

    @Override
    public Object valueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        return DocValueFormat.IP.format((BytesRef)value);
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        if (format != null) {
            String message = "Runtime field [%s] of type [%s] does not support custom formats";
            throw new IllegalArgumentException(String.format(Locale.ROOT, message, this.name(), this.typeName()));
        }
        if (timeZone != null) {
            String message = "Runtime field [%s] of type [%s] does not support custom time zones";
            throw new IllegalArgumentException(String.format(Locale.ROOT, message, this.name(), this.typeName()));
        }
        return DocValueFormat.IP;
    }

    @Override
    public IpScriptFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return new IpScriptFieldData.Builder(this.name(), (IpFieldScript.LeafFactory)this.leafFactory(searchLookup.get()));
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new IpScriptFieldExistsQuery(this.script, (IpFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return IpFieldMapper.IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> new IpScriptFieldRangeQuery(this.script, (IpFieldScript.LeafFactory)this.leafFactory(context), this.name(), new BytesRef(InetAddressPoint.encode((InetAddress)lower)), new BytesRef(InetAddressPoint.encode((InetAddress)upper))));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        if (value instanceof InetAddress) {
            return this.inetAddressQuery((InetAddress)value, context);
        }
        String term = BytesRefs.toString(value);
        if (term.contains("/")) {
            return this.cidrQuery(term, context);
        }
        InetAddress address = InetAddresses.forString(term);
        return this.inetAddressQuery(address, context);
    }

    private Query inetAddressQuery(InetAddress address, SearchExecutionContext context) {
        return new IpScriptFieldTermQuery(this.script, (IpFieldScript.LeafFactory)this.leafFactory(context), this.name(), new BytesRef(InetAddressPoint.encode((InetAddress)address)));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        BytesRefHash terms = new BytesRefHash(values.size(), BigArrays.NON_RECYCLING_INSTANCE);
        ArrayList<Query> cidrQueries = null;
        for (Object value : values) {
            if (value instanceof InetAddress) {
                terms.add(new BytesRef(InetAddressPoint.encode((InetAddress)((InetAddress)value))));
                continue;
            }
            String term = BytesRefs.toString(value);
            if (!term.contains("/")) {
                terms.add(new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(term))));
                continue;
            }
            if (cidrQueries == null) {
                cidrQueries = new ArrayList<Query>();
            }
            cidrQueries.add(this.cidrQuery(term, context));
        }
        IpScriptFieldTermsQuery termsQuery = new IpScriptFieldTermsQuery(this.script, (IpFieldScript.LeafFactory)this.leafFactory(context), this.name(), terms);
        if (cidrQueries == null) {
            return termsQuery;
        }
        BooleanQuery.Builder bool = new BooleanQuery.Builder();
        bool.add(termsQuery, BooleanClause.Occur.SHOULD);
        for (Query cidrQuery : cidrQueries) {
            bool.add(cidrQuery, BooleanClause.Occur.SHOULD);
        }
        return bool.build();
    }

    private Query cidrQuery(String term, SearchExecutionContext context) {
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
        InetAddress addr = cidr.v1();
        int prefixLength = cidr.v2();
        byte[] lower = addr.getAddress();
        byte[] upper = addr.getAddress();
        for (int i = prefixLength; i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        BytesRef lowerBytes = new BytesRef(InetAddressPoint.encode((InetAddress)InetAddressPoint.decode((byte[])lower)));
        BytesRef upperBytes = new BytesRef(InetAddressPoint.encode((InetAddress)InetAddressPoint.decode((byte[])upper)));
        return new IpScriptFieldRangeQuery(this.script, (IpFieldScript.LeafFactory)this.leafFactory(context), this.name(), lowerBytes, upperBytes);
    }
}

