/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.nio.ByteBuffer;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class Page
implements Releasable {
    private final ByteBuffer byteBuffer;
    private final RefCountedCloseable refCountedCloseable;

    public Page(ByteBuffer byteBuffer, Releasable closeable) {
        this(byteBuffer, new RefCountedCloseable(closeable));
    }

    private Page(ByteBuffer byteBuffer, RefCountedCloseable refCountedCloseable) {
        assert (refCountedCloseable.refCount() > 0);
        this.byteBuffer = byteBuffer;
        this.refCountedCloseable = refCountedCloseable;
    }

    public Page duplicate() {
        this.refCountedCloseable.incRef();
        return new Page(this.byteBuffer.duplicate(), this.refCountedCloseable);
    }

    public ByteBuffer byteBuffer() {
        assert (this.refCountedCloseable.refCount() > 0);
        return this.byteBuffer;
    }

    @Override
    public void close() {
        this.refCountedCloseable.decRef();
    }

    private static class RefCountedCloseable
    extends AbstractRefCounted {
        private final Releasable closeable;

        private RefCountedCloseable(Releasable closeable) {
            super("byte array page");
            this.closeable = closeable;
        }

        @Override
        protected void closeInternal() {
            Releasables.closeExpectNoException(this.closeable);
        }
    }
}

