/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.search.lookup.SourceLookup;

abstract class AbstractSortScript
extends DocBasedScript
implements ScorerAware {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.core.Map.of("doc", value -> {
        deprecationLogger.deprecate(DeprecationCategory.SCRIPTING, "sort-script_doc", "Accessing variable [doc] via [params.doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate(DeprecationCategory.SCRIPTING, "sort-script__doc", "Accessing variable [doc] via [params._doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).source());
    private final Map<String, Object> params;
    private Scorable scorer;

    AbstractSortScript(Map<String, Object> params, DocReader docReader) {
        super(docReader);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.putAll(docReader.docAsMap());
        this.params = new DynamicMap(parameters, PARAMS_FUNCTIONS);
    }

    protected AbstractSortScript() {
        super(null);
        this.params = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public double get_score() {
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }
}

