/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FutureArrays;

public class MergedPointRangeQuery
extends Query {
    private final String field;
    private final Query delegateForMultiValuedSegments;
    private final Query delegateForSingleValuedSegments;

    public static Query merge(PointRangeQuery lhs, PointRangeQuery rhs) {
        if (lhs.equals(rhs)) {
            return lhs;
        }
        if (lhs.getField() != rhs.getField() || lhs.getNumDims() != rhs.getNumDims() || lhs.getBytesPerDim() != rhs.getBytesPerDim()) {
            return null;
        }
        return new MergedPointRangeQuery(lhs, rhs);
    }

    private MergedPointRangeQuery(PointRangeQuery lhs, PointRangeQuery rhs) {
        this.field = lhs.getField();
        this.delegateForMultiValuedSegments = new BooleanQuery.Builder().add(lhs, BooleanClause.Occur.MUST).add(rhs, BooleanClause.Occur.MUST).build();
        int numDims = lhs.getNumDims();
        int bytesPerDim = lhs.getBytesPerDim();
        this.delegateForSingleValuedSegments = this.pickDelegateForSingleValuedSegments(MergedPointRangeQuery.mergeBound(lhs.getLowerPoint(), rhs.getLowerPoint(), numDims, bytesPerDim, true), MergedPointRangeQuery.mergeBound(lhs.getUpperPoint(), rhs.getUpperPoint(), numDims, bytesPerDim, false), numDims, bytesPerDim);
    }

    private Query pickDelegateForSingleValuedSegments(byte[] lower, byte[] upper, int numDims, int bytesPerDim) {
        for (int dim = 0; dim < numDims; ++dim) {
            int offset = dim * bytesPerDim;
            if (FutureArrays.compareUnsigned(lower, offset, offset + bytesPerDim, upper, offset, offset + bytesPerDim) <= 0) continue;
            return new MatchNoDocsQuery("disjoint ranges");
        }
        return new PointRangeQuery(this.field, lower, upper, numDims){

            @Override
            protected String toString(int dimension, byte[] value) {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                for (int i = 0; i < value.length; ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(Integer.toHexString(value[i] & 0xFF));
                }
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            Weight multiValuedSegmentWeight;
            Weight singleValuedSegmentWeight;

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                PointValues points = context.reader().getPointValues(MergedPointRangeQuery.this.field);
                if (points == null) {
                    return null;
                }
                if (points.size() == (long)points.getDocCount()) {
                    return this.singleValuedSegmentWeight().scorerSupplier(context);
                }
                return this.multiValuedSegmentWeight().scorerSupplier(context);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                PointValues points = context.reader().getPointValues(MergedPointRangeQuery.this.field);
                if (points == null) {
                    return null;
                }
                if (points.size() == (long)points.getDocCount()) {
                    return this.singleValuedSegmentWeight().bulkScorer(context);
                }
                return this.multiValuedSegmentWeight().bulkScorer(context);
            }

            private Weight singleValuedSegmentWeight() throws IOException {
                if (this.singleValuedSegmentWeight == null) {
                    this.singleValuedSegmentWeight = MergedPointRangeQuery.this.delegateForSingleValuedSegments.createWeight(searcher, scoreMode, boost);
                }
                return this.singleValuedSegmentWeight;
            }

            private Weight multiValuedSegmentWeight() throws IOException {
                if (this.multiValuedSegmentWeight == null) {
                    this.multiValuedSegmentWeight = MergedPointRangeQuery.this.delegateForMultiValuedSegments.createWeight(searcher, scoreMode, boost);
                }
                return this.multiValuedSegmentWeight;
            }
        };
    }

    Query delegateForSingleValuedSegments() {
        return this.delegateForSingleValuedSegments;
    }

    @Override
    public String toString(String field) {
        return "MergedPointRange[" + this.delegateForMultiValuedSegments.toString(field) + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        MergedPointRangeQuery other = (MergedPointRangeQuery)obj;
        return this.delegateForMultiValuedSegments.equals(other.delegateForMultiValuedSegments) && this.delegateForSingleValuedSegments.equals(other.delegateForSingleValuedSegments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.delegateForMultiValuedSegments, this.delegateForSingleValuedSegments);
    }

    private static byte[] mergeBound(byte[] lhs, byte[] rhs, int numDims, int bytesPerDim, boolean lower) {
        byte[] merged = new byte[lhs.length];
        for (int dim = 0; dim < numDims; ++dim) {
            int offset = dim * bytesPerDim;
            boolean cmp = FutureArrays.compareUnsigned(lhs, offset, offset + bytesPerDim, rhs, offset, offset + bytesPerDim) <= 0;
            byte[] from = cmp ^ lower ? lhs : rhs;
            System.arraycopy(from, offset, merged, offset, bytesPerDim);
        }
        return merged;
    }
}

