/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;

class TermQueryToFilterAdapter
extends QueryToFilterAdapter<TermQuery> {
    private int resultsFromMetadata;

    TermQueryToFilterAdapter(IndexSearcher searcher, String key, TermQuery query) {
        super(searcher, key, query);
    }

    @Override
    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
        if (this.countCanUseMetadata(counter, live)) {
            ++this.resultsFromMetadata;
            return ctx.reader().docFreq(((TermQuery)this.query()).getTerm());
        }
        return super.count(ctx, counter, live);
    }

    @Override
    void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("specialized_for", "term");
        add.accept("results_from_metadata", this.resultsFromMetadata);
    }
}

