/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedVariableWidthHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private static ObjectParser<ParsedVariableWidthHistogram, Void> PARSER = new ObjectParser(ParsedVariableWidthHistogram.class.getSimpleName(), true, ParsedVariableWidthHistogram::new);

    @Override
    public String getType() {
        return "variable_width_histogram";
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedVariableWidthHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedVariableWidthHistogram aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedVariableWidthHistogram.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Double key;
        private Double min;
        private Double max;
        private String minAsString;
        private String maxAsString;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Double.toString(this.key);
            }
            return null;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public void setMinAsString(String minAsString) {
            this.minAsString = minAsString;
        }

        public double getMin() {
            return this.min;
        }

        public String getMinAsString() {
            if (this.minAsString != null) {
                return this.minAsString;
            }
            if (this.min != null) {
                return Double.toString(this.min);
            }
            return null;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public void setMaxAsString(String maxAsString) {
            this.maxAsString = maxAsString;
        }

        public double getMax() {
            return this.max;
        }

        public String getMaxAsString() {
            if (this.maxAsString != null) {
                return this.maxAsString;
            }
            if (this.max != null) {
                return Double.toString(this.max);
            }
            return null;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            ParsedBucket bucket = new ParsedBucket();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setKeyAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        bucket.key = parser.doubleValue();
                        continue;
                    }
                    if (Aggregation.CommonFields.MIN_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setMinAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.MIN.getPreferredName().equals(currentFieldName)) {
                        bucket.setMin(parser.doubleValue());
                        continue;
                    }
                    if (Aggregation.CommonFields.MAX_AS_STRING.getPreferredName().equals(currentFieldName)) {
                        bucket.setMaxAsString(parser.text());
                        continue;
                    }
                    if (Aggregation.CommonFields.MAX.getPreferredName().equals(currentFieldName)) {
                        bucket.setMax(parser.doubleValue());
                        continue;
                    }
                    if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                    bucket.setDocCount(parser.longValue());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                    bucket.key = parser.doubleValue();
                    continue;
                }
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return bucket;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.isKeyed()) {
                builder.startObject(this.getKeyAsString());
            } else {
                builder.startObject();
            }
            if (this.minAsString != null) {
                builder.field(Aggregation.CommonFields.MIN_AS_STRING.getPreferredName(), this.minAsString);
            }
            builder.field(Aggregation.CommonFields.MIN.getPreferredName(), this.getMin());
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            this.keyToXContent(builder);
            if (this.maxAsString != null) {
                builder.field(Aggregation.CommonFields.MAX_AS_STRING.getPreferredName(), this.maxAsString);
            }
            builder.field(Aggregation.CommonFields.MAX.getPreferredName(), this.getMax());
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

