/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FutureArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class MaxAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat formatter;
    final String pointField;
    final Function<byte[], Number> pointConverter;
    DoubleArray maxes;

    MaxAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        ValuesSource.Numeric numeric = this.valuesSource = config.hasValues() ? (ValuesSource.Numeric)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = config.format();
        this.pointConverter = this.pointReaderIfAvailable(config);
        this.pointField = this.pointConverter != null ? config.fieldContext().field() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        Number segMax;
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        if (this.pointConverter != null && (segMax = MaxAggregator.findLeafMaxValue(ctx.reader(), this.pointField, this.pointConverter)) != null) {
            assert (this.maxes.size() == 1L);
            double max = this.maxes.get(0L);
            max = Math.max(max, segMax.doubleValue());
            this.maxes.set(0L, max);
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(ctx);
        final NumericDoubleValues values = MultiValueMode.MAX.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MaxAggregator.this.maxes.size()) {
                    long from = MaxAggregator.this.maxes.size();
                    MaxAggregator.this.maxes = MaxAggregator.this.bigArrays().grow(MaxAggregator.this.maxes, bucket + 1L);
                    MaxAggregator.this.maxes.fill(from, MaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double max = MaxAggregator.this.maxes.get(bucket);
                    max = Math.max(max, value);
                    MaxAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }

    static Number findLeafMaxValue(LeafReader reader, String fieldName, Function<byte[], Number> converter) throws IOException {
        PointValues pointValues = reader.getPointValues(fieldName);
        if (pointValues == null) {
            return null;
        }
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return converter.apply(pointValues.getMaxPackedValue());
        }
        final int numBytes = pointValues.getBytesPerDimension();
        final byte[] maxValue = pointValues.getMaxPackedValue();
        final byte[][] result = new byte[1][];
        pointValues.intersect(new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visit(int docID, byte[] packedValue) {
                if (liveDocs.get(docID)) {
                    if (result[0] == null) {
                        result[0] = new byte[packedValue.length];
                    }
                    System.arraycopy(packedValue, 0, result[0], 0, packedValue.length);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (FutureArrays.equals(maxValue, 0, numBytes, maxPackedValue, 0, numBytes)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        });
        return result[0] != null ? (Number)converter.apply(result[0]) : (Number)null;
    }
}

