/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public class BucketHelpers {
    public static Double resolveBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath, GapPolicy gapPolicy) {
        List<String> aggPathsList = AggregationPath.parse(aggPath).getPathElementsAsStringList();
        return BucketHelpers.resolveBucketValue(agg, bucket, aggPathsList, gapPolicy);
    }

    public static Double resolveBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, List<String> aggPathAsList, GapPolicy gapPolicy) {
        try {
            double value;
            Object propertyValue = bucket.getProperty(agg.getName(), aggPathAsList);
            if (propertyValue == null) {
                throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation");
            }
            if (propertyValue instanceof Number) {
                value = ((Number)propertyValue).doubleValue();
            } else if (propertyValue instanceof InternalNumericMetricsAggregation.SingleValue) {
                value = ((InternalNumericMetricsAggregation.SingleValue)propertyValue).value();
            } else {
                throw BucketHelpers.formatResolutionError(agg, aggPathAsList, propertyValue);
            }
            if (aggPathAsList.size() == 1 && "_count".equals(aggPathAsList.get(0))) {
                return value;
            }
            return gapPolicy.processValue(bucket.getDocCount(), value);
        }
        catch (InvalidAggregationPathException e) {
            return null;
        }
    }

    private static AggregationExecutionException formatResolutionError(MultiBucketsAggregation agg, List<String> aggPathAsList, Object propertyValue) {
        Object currentAgg;
        String currentAggName;
        if (aggPathAsList.isEmpty()) {
            currentAggName = agg.getName();
            currentAgg = agg;
        } else {
            currentAggName = aggPathAsList.get(0);
            currentAgg = propertyValue;
        }
        if (currentAgg instanceof InternalNumericMetricsAggregation.MultiValue) {
            return new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation, but [" + currentAggName + "] contains multiple values. Please specify which to use.");
        }
        return new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation, got: [" + propertyValue.getClass().getSimpleName() + "] at aggregation [" + currentAggName + "]");
    }

    public static enum GapPolicy implements Writeable
    {
        INSERT_ZEROS(0, "insert_zeros", false){

            @Override
            public Double processValue(long docCount, Double value) {
                if (Double.isInfinite(value) || Double.isNaN(value) || docCount == 0L) {
                    return 0.0;
                }
                return value;
            }
        }
        ,
        SKIP(1, "skip", true){

            @Override
            public Double processValue(long docCount, Double value) {
                if (Double.isInfinite(value) || docCount == 0L) {
                    return Double.NaN;
                }
                return value;
            }
        }
        ,
        KEEP_VALUES(2, "keep_values", true){

            @Override
            public Double processValue(long docCount, Double value) {
                if (Double.isInfinite(value) || Double.isNaN(value)) {
                    return Double.NaN;
                }
                return value;
            }
        };

        private final byte id;
        private final ParseField parseField;
        public final boolean isSkippable;

        public static GapPolicy parse(String text, XContentLocation tokenLocation) {
            GapPolicy result = null;
            for (GapPolicy policy : GapPolicy.values()) {
                if (!policy.parseField.match(text, LoggingDeprecationHandler.INSTANCE)) continue;
                if (result == null) {
                    result = policy;
                    continue;
                }
                throw new IllegalStateException("Text can be parsed to 2 different gap policies: text=[" + text + "], policies=" + Arrays.asList(result, policy));
            }
            if (result == null) {
                ArrayList<String> validNames = new ArrayList<String>();
                for (GapPolicy policy : GapPolicy.values()) {
                    validNames.add(policy.getName());
                }
                throw new ParsingException(tokenLocation, "Invalid gap policy: [" + text + "], accepted values: " + validNames, new Object[0]);
            }
            return result;
        }

        private GapPolicy(byte id, String name, boolean isSkippable) {
            this.id = id;
            this.parseField = new ParseField(name, new String[0]);
            this.isSkippable = isSkippable;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public static GapPolicy readFrom(StreamInput in) throws IOException {
            byte id = in.readByte();
            for (GapPolicy gapPolicy : GapPolicy.values()) {
                if (id != gapPolicy.id) continue;
                return gapPolicy;
            }
            throw new IllegalStateException("Unknown GapPolicy with id [" + id + "]");
        }

        public String getName() {
            return this.parseField.getPreferredName();
        }

        public abstract Double processValue(long var1, Double var3);
    }
}

