/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.search.internal.FilterFieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.search.internal.FilterStoredFieldVisitor;

public class FieldUsageTrackingDirectoryReader
extends FilterDirectoryReader {
    private final FieldUsageNotifier notifier;

    public FieldUsageTrackingDirectoryReader(DirectoryReader in, final FieldUsageNotifier notifier) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return new FieldUsageTrackingLeafReader(reader, notifier);
            }
        });
        this.notifier = notifier;
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new FieldUsageTrackingDirectoryReader(in, this.notifier);
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static interface FieldUsageNotifier {
        public void onTermsUsed(String var1);

        public void onPostingsUsed(String var1);

        public void onTermFrequenciesUsed(String var1);

        public void onPositionsUsed(String var1);

        public void onOffsetsUsed(String var1);

        public void onDocValuesUsed(String var1);

        public void onStoredFieldsUsed(String var1);

        public void onNormsUsed(String var1);

        public void onPayloadsUsed(String var1);

        public void onPointsUsed(String var1);

        public void onTermVectorsUsed(String var1);
    }

    public static final class FieldUsageTrackingLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final FieldUsageNotifier notifier;

        public FieldUsageTrackingLeafReader(LeafReader in, FieldUsageNotifier notifier) {
            super(in);
            this.notifier = notifier;
        }

        @Override
        public Fields getTermVectors(int docID) throws IOException {
            Fields f = super.getTermVectors(docID);
            if (f != null) {
                f = new FieldUsageTrackingTermVectorFields(f);
            }
            return f;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = super.getPointValues(field);
            if (pointValues != null) {
                this.notifier.onPointsUsed(field);
            }
            return pointValues;
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            if (visitor instanceof FieldNamesProvidingStoredFieldsVisitor) {
                super.document(docID, new FieldUsageFieldsVisitor((FieldNamesProvidingStoredFieldsVisitor)visitor));
            } else {
                super.document(docID, new FieldUsageStoredFieldVisitor(visitor));
            }
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            if (terms != null) {
                this.notifier.onTermsUsed(field);
                if (!(terms instanceof CompletionTerms)) {
                    terms = new FieldUsageTrackingTerms(field, terms);
                }
            }
            return terms;
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            BinaryDocValues binaryDocValues = super.getBinaryDocValues(field);
            if (binaryDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return binaryDocValues;
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            SortedDocValues sortedDocValues = super.getSortedDocValues(field);
            if (sortedDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedDocValues;
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            SortedNumericDocValues sortedNumericDocValues = super.getSortedNumericDocValues(field);
            if (sortedNumericDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedNumericDocValues;
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            SortedSetDocValues sortedSetDocValues = super.getSortedSetDocValues(field);
            if (sortedSetDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedSetDocValues;
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            NumericDocValues numericDocValues = super.getNormValues(field);
            if (numericDocValues != null) {
                this.notifier.onNormsUsed(field);
            }
            return numericDocValues;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("FieldUsageTrackingLeafReader(reader=");
            return sb.append(this.in).append(')').toString();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return new FieldUsageTrackingStoredFieldsReader(reader);
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        private class FieldUsageTrackingTermVectorFields
        extends FilterLeafReader.FilterFields {
            FieldUsageTrackingTermVectorFields(Fields in) {
                super(in);
            }

            @Override
            public Terms terms(String field) throws IOException {
                Terms terms = super.terms(field);
                if (terms != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onTermVectorsUsed(field);
                }
                return terms;
            }
        }

        private class FieldUsageFieldsVisitor
        extends FilterFieldNamesProvidingStoredFieldsVisitor {
            FieldUsageFieldsVisitor(FieldNamesProvidingStoredFieldsVisitor visitor) {
                super(visitor);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                StoredFieldVisitor.Status status = super.needsField(fieldInfo);
                if (status == StoredFieldVisitor.Status.YES) {
                    FieldUsageTrackingLeafReader.this.notifier.onStoredFieldsUsed(fieldInfo.name);
                }
                return status;
            }
        }

        private class FieldUsageStoredFieldVisitor
        extends FilterStoredFieldVisitor {
            FieldUsageStoredFieldVisitor(StoredFieldVisitor visitor) {
                super(visitor);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                StoredFieldVisitor.Status status = super.needsField(fieldInfo);
                if (status == StoredFieldVisitor.Status.YES) {
                    FieldUsageTrackingLeafReader.this.notifier.onStoredFieldsUsed(fieldInfo.name);
                }
                return status;
            }
        }

        private class FieldUsageTrackingTerms
        extends FilterLeafReader.FilterTerms {
            private final String field;

            FieldUsageTrackingTerms(String field, Terms in) {
                super(in);
                this.field = field;
            }

            @Override
            public TermsEnum iterator() throws IOException {
                TermsEnum termsEnum = this.in.iterator();
                if (termsEnum != null) {
                    termsEnum = new FieldUsageTrackingTermsEnum(this.field, termsEnum);
                }
                return termsEnum;
            }

            @Override
            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                TermsEnum termsEnum = this.in.intersect(compiled, startTerm);
                if (termsEnum != null) {
                    termsEnum = new FieldUsageTrackingTermsEnum(this.field, termsEnum);
                }
                return termsEnum;
            }

            @Override
            public long getSumTotalTermFreq() throws IOException {
                long totalTermFreq = super.getSumTotalTermFreq();
                FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                return totalTermFreq;
            }

            @Override
            public long getSumDocFreq() throws IOException {
                return this.in.getSumDocFreq();
            }
        }

        class FieldUsageTrackingStoredFieldsReader
        extends StoredFieldsReader {
            final StoredFieldsReader reader;

            FieldUsageTrackingStoredFieldsReader(StoredFieldsReader reader) {
                this.reader = reader;
            }

            @Override
            public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                this.reader.visitDocument(docID, new FieldUsageStoredFieldVisitor(visitor));
            }

            @Override
            public StoredFieldsReader clone() {
                return new FieldUsageTrackingStoredFieldsReader(this.reader.clone());
            }

            @Override
            public StoredFieldsReader getMergeInstance() {
                return new FieldUsageTrackingStoredFieldsReader(this.reader.getMergeInstance());
            }

            @Override
            public void checkIntegrity() throws IOException {
                this.reader.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }

            @Override
            public long ramBytesUsed() {
                return this.reader.ramBytesUsed();
            }
        }

        private class FieldUsageTrackingTermsEnum
        extends FilterLeafReader.FilterTermsEnum {
            private final String field;

            FieldUsageTrackingTermsEnum(String field, TermsEnum in) {
                super(in);
                this.field = field;
            }

            @Override
            public long totalTermFreq() throws IOException {
                long totalTermFreq = super.totalTermFreq();
                FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                return totalTermFreq;
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                PostingsEnum postingsEnum = super.postings(reuse, flags);
                if (postingsEnum != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onPostingsUsed(this.field);
                    this.checkPostingsFlags(flags);
                }
                return postingsEnum;
            }

            @Override
            public ImpactsEnum impacts(int flags) throws IOException {
                ImpactsEnum impactsEnum = super.impacts(flags);
                if (impactsEnum != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onPostingsUsed(this.field);
                    this.checkPostingsFlags(flags);
                }
                return impactsEnum;
            }

            private void checkPostingsFlags(int flags) {
                if (PostingsEnum.featureRequested(flags, (short)8)) {
                    FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                }
                if (PostingsEnum.featureRequested(flags, (short)24)) {
                    FieldUsageTrackingLeafReader.this.notifier.onPositionsUsed(this.field);
                }
                if (PostingsEnum.featureRequested(flags, (short)56)) {
                    FieldUsageTrackingLeafReader.this.notifier.onOffsetsUsed(this.field);
                }
                if (PostingsEnum.featureRequested(flags, (short)88)) {
                    FieldUsageTrackingLeafReader.this.notifier.onPayloadsUsed(this.field);
                }
            }
        }
    }
}

