/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.DeflateTransportDecompressor;
import org.elasticsearch.transport.Lz4TransportDecompressor;

public interface TransportDecompressor
extends Releasable {
    public int decompress(BytesReference var1) throws IOException;

    public ReleasableBytesReference pollDecompressedPage(boolean var1);

    public Compression.Scheme getScheme();

    @Override
    public void close();

    public static TransportDecompressor getDecompressor(PageCacheRecycler recycler, BytesReference bytes) throws IOException {
        if (bytes.length() < 4) {
            return null;
        }
        if (Compression.Scheme.isDeflate(bytes)) {
            return new DeflateTransportDecompressor(recycler);
        }
        if (Compression.Scheme.isLZ4(bytes)) {
            return new Lz4TransportDecompressor(recycler);
        }
        throw TransportDecompressor.createIllegalState(bytes);
    }

    public static IllegalStateException createIllegalState(BytesReference bytes) {
        int maxToRead = Math.min(bytes.length(), 10);
        StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(bytes.length()).append("] readable bytes with message size [").append(bytes.length()).append("] ").append("] are [");
        for (int i = 0; i < maxToRead; ++i) {
            sb.append(bytes.get(i)).append(",");
        }
        sb.append("]");
        return new IllegalStateException(sb.toString());
    }
}

