/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;
import org.elasticsearch.index.shard.IndexSettingProvider;

public class DataTier {
    public static final String DATA_CONTENT = "data_content";
    public static final String DATA_HOT = "data_hot";
    public static final String DATA_WARM = "data_warm";
    public static final String DATA_COLD = "data_cold";
    public static final String DATA_FROZEN = "data_frozen";
    public static final Set<String> ALL_DATA_TIERS = new HashSet<String>(Arrays.asList("data_content", "data_hot", "data_warm", "data_cold", "data_frozen"));
    private static final java.util.List<String> ORDERED_FROZEN_TO_HOT_TIERS = List.of("data_frozen", "data_cold", "data_warm", "data_hot");

    public static boolean validTierName(String tierName) {
        return DATA_CONTENT.equals(tierName) || DATA_HOT.equals(tierName) || DATA_WARM.equals(tierName) || DATA_COLD.equals(tierName) || DATA_FROZEN.equals(tierName);
    }

    public static String getPreferredTiersConfiguration(String targetTier) {
        int indexOfTargetTier = ORDERED_FROZEN_TO_HOT_TIERS.indexOf(targetTier);
        if (indexOfTargetTier == -1) {
            throw new IllegalArgumentException("invalid data tier [" + targetTier + "]");
        }
        return ORDERED_FROZEN_TO_HOT_TIERS.stream().skip(indexOfTargetTier).collect(Collectors.joining(","));
    }

    public static boolean isExplicitDataTier(Settings settings) {
        if (settings.hasValue("node.roles")) {
            return settings.getAsList("node.roles").stream().anyMatch(DataTier::validTierName);
        }
        return false;
    }

    public static boolean isContentNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_CONTENT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isHotNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_HOT_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isWarmNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_WARM_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isColdNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_COLD_NODE_ROLE) || discoveryNode.getRoles().contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static boolean isFrozenNode(DiscoveryNode discoveryNode) {
        return DataTier.isFrozenNode(discoveryNode.getRoles());
    }

    public static boolean isFrozenNode(Set<DiscoveryNodeRole> roles) {
        return roles.contains(DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE) || roles.contains(DiscoveryNodeRole.DATA_ROLE);
    }

    public static class DefaultHotAllocationSettingProvider
    implements IndexSettingProvider {
        private static final Logger logger = LogManager.getLogger(DefaultHotAllocationSettingProvider.class);

        @Override
        public Settings getAdditionalIndexSettings(String indexName, boolean isDataStreamIndex, Settings indexSettings) {
            Set<String> settings = indexSettings.keySet();
            if (settings.contains("index.routing.allocation.include._tier_preference")) {
                return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_HOT).build();
            }
            if (settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.require.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.exclude.")) || settings.stream().anyMatch(s -> s.startsWith("index.routing.allocation.include."))) {
                logger.debug("index [{}] specifies custom index level routing filtering, skipping tier allocation", (Object)indexName);
                return Settings.EMPTY;
            }
            if (isDataStreamIndex) {
                return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_HOT).build();
            }
            return Settings.builder().put("index.routing.allocation.include._tier_preference", DataTier.DATA_CONTENT).build();
        }
    }
}

