/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;

public class AutoFollowStats
implements Writeable,
ToXContentObject {
    private static final ParseField NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED = new ParseField("number_of_successful_follow_indices", new String[0]);
    private static final ParseField NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED = new ParseField("number_of_failed_follow_indices", new String[0]);
    private static final ParseField NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS = new ParseField("number_of_failed_remote_cluster_state_requests", new String[0]);
    private static final ParseField RECENT_AUTO_FOLLOW_ERRORS = new ParseField("recent_auto_follow_errors", new String[0]);
    private static final ParseField LEADER_INDEX = new ParseField("leader_index", new String[0]);
    private static final ParseField AUTO_FOLLOW_EXCEPTION = new ParseField("auto_follow_exception", new String[0]);
    private static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    private static final ParseField AUTO_FOLLOWED_CLUSTERS = new ParseField("auto_followed_clusters", new String[0]);
    private static final ParseField CLUSTER_NAME = new ParseField("cluster_name", new String[0]);
    private static final ParseField TIME_SINCE_LAST_CHECK_MILLIS = new ParseField("time_since_last_check_millis", new String[0]);
    private static final ParseField LAST_SEEN_METADATA_VERSION = new ParseField("last_seen_metadata_version", new String[0]);
    private static final ConstructingObjectParser<AutoFollowStats, Void> STATS_PARSER = new ConstructingObjectParser("auto_follow_stats", args -> new AutoFollowStats((Long)args[0], (Long)args[1], (Long)args[2], new TreeMap<String, Tuple<Long, ElasticsearchException>>(((List)args[3]).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), new TreeMap<String, AutoFollowedCluster>(((List)args[4]).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))));
    private static final ConstructingObjectParser<Map.Entry<String, Tuple<Long, ElasticsearchException>>, Void> AUTO_FOLLOW_EXCEPTIONS_PARSER = new ConstructingObjectParser("auto_follow_stats_errors", args -> new AbstractMap.SimpleEntry<String, Tuple<Long, ElasticsearchException>>((String)args[0], new Tuple<Long, ElasticsearchException>((Long)args[1], (ElasticsearchException)args[2])));
    private static final ConstructingObjectParser<Map.Entry<String, AutoFollowedCluster>, Void> AUTO_FOLLOWED_CLUSTERS_PARSER = new ConstructingObjectParser("auto_followed_clusters", args -> new AbstractMap.SimpleEntry<String, AutoFollowedCluster>((String)args[0], new AutoFollowedCluster((Long)args[1], (Long)args[2])));
    private final long numberOfFailedFollowIndices;
    private final long numberOfFailedRemoteClusterStateRequests;
    private final long numberOfSuccessfulFollowIndices;
    private final NavigableMap<String, Tuple<Long, ElasticsearchException>> recentAutoFollowErrors;
    private final NavigableMap<String, AutoFollowedCluster> autoFollowedClusters;

    public static AutoFollowStats fromXContent(XContentParser parser) {
        return STATS_PARSER.apply(parser, null);
    }

    public AutoFollowStats(long numberOfFailedFollowIndices, long numberOfFailedRemoteClusterStateRequests, long numberOfSuccessfulFollowIndices, NavigableMap<String, Tuple<Long, ElasticsearchException>> recentAutoFollowErrors, NavigableMap<String, AutoFollowedCluster> autoFollowedClusters) {
        this.numberOfFailedFollowIndices = numberOfFailedFollowIndices;
        this.numberOfFailedRemoteClusterStateRequests = numberOfFailedRemoteClusterStateRequests;
        this.numberOfSuccessfulFollowIndices = numberOfSuccessfulFollowIndices;
        this.recentAutoFollowErrors = recentAutoFollowErrors;
        this.autoFollowedClusters = autoFollowedClusters;
    }

    public AutoFollowStats(StreamInput in) throws IOException {
        this.numberOfFailedFollowIndices = in.readVLong();
        this.numberOfFailedRemoteClusterStateRequests = in.readVLong();
        this.numberOfSuccessfulFollowIndices = in.readVLong();
        this.recentAutoFollowErrors = in.getVersion().onOrAfter(Version.V_6_7_0) ? new TreeMap<String, Tuple>(in.readMap(StreamInput::readString, in1 -> new Tuple<Long, ElasticsearchException>(in1.readZLong(), (ElasticsearchException)in1.readException()))) : new TreeMap<String, Tuple>(in.readMap(StreamInput::readString, in1 -> new Tuple<Long, ElasticsearchException>(-1L, (ElasticsearchException)in1.readException())));
        this.autoFollowedClusters = in.getVersion().onOrAfter(Version.V_6_6_0) ? new TreeMap<String, AutoFollowedCluster>(in.readMap(StreamInput::readString, AutoFollowedCluster::new)) : Collections.emptyNavigableMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numberOfFailedFollowIndices);
        out.writeVLong(this.numberOfFailedRemoteClusterStateRequests);
        out.writeVLong(this.numberOfSuccessfulFollowIndices);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeMap(this.recentAutoFollowErrors, StreamOutput::writeString, (out1, value) -> {
                out1.writeZLong((Long)value.v1());
                out1.writeException((Throwable)value.v2());
            });
        } else {
            out.writeMap(this.recentAutoFollowErrors, StreamOutput::writeString, (out1, value) -> out1.writeException((Throwable)value.v2()));
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeMap(this.autoFollowedClusters, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        }
    }

    public long getNumberOfFailedFollowIndices() {
        return this.numberOfFailedFollowIndices;
    }

    public long getNumberOfFailedRemoteClusterStateRequests() {
        return this.numberOfFailedRemoteClusterStateRequests;
    }

    public long getNumberOfSuccessfulFollowIndices() {
        return this.numberOfSuccessfulFollowIndices;
    }

    public NavigableMap<String, Tuple<Long, ElasticsearchException>> getRecentAutoFollowErrors() {
        return this.recentAutoFollowErrors;
    }

    public NavigableMap<String, AutoFollowedCluster> getAutoFollowedClusters() {
        return this.autoFollowedClusters;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED.getPreferredName(), this.numberOfFailedFollowIndices);
        builder.field(NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS.getPreferredName(), this.numberOfFailedRemoteClusterStateRequests);
        builder.field(NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED.getPreferredName(), this.numberOfSuccessfulFollowIndices);
        builder.startArray(RECENT_AUTO_FOLLOW_ERRORS.getPreferredName());
        for (Map.Entry entry : this.recentAutoFollowErrors.entrySet()) {
            builder.startObject();
            builder.field(LEADER_INDEX.getPreferredName(), (String)entry.getKey());
            builder.field(TIMESTAMP.getPreferredName(), (Long)((Tuple)entry.getValue()).v1());
            builder.field(AUTO_FOLLOW_EXCEPTION.getPreferredName());
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, (Throwable)((Tuple)entry.getValue()).v2());
            builder.endObject();
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(AUTO_FOLLOWED_CLUSTERS.getPreferredName());
        for (Map.Entry entry : this.autoFollowedClusters.entrySet()) {
            builder.startObject();
            builder.field(CLUSTER_NAME.getPreferredName(), (String)entry.getKey());
            builder.field(TIME_SINCE_LAST_CHECK_MILLIS.getPreferredName(), ((AutoFollowedCluster)entry.getValue()).getTimeSinceLastCheckMillis());
            builder.field(LAST_SEEN_METADATA_VERSION.getPreferredName(), ((AutoFollowedCluster)entry.getValue()).getLastSeenMetadataVersion());
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoFollowStats that = (AutoFollowStats)o;
        return this.numberOfFailedFollowIndices == that.numberOfFailedFollowIndices && this.numberOfFailedRemoteClusterStateRequests == that.numberOfFailedRemoteClusterStateRequests && this.numberOfSuccessfulFollowIndices == that.numberOfSuccessfulFollowIndices && this.recentAutoFollowErrors.keySet().equals(that.recentAutoFollowErrors.keySet()) && AutoFollowStats.getFetchExceptionMessages(this).equals(AutoFollowStats.getFetchExceptionMessages(that)) && Objects.equals(this.autoFollowedClusters, that.autoFollowedClusters);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfFailedFollowIndices, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulFollowIndices, this.recentAutoFollowErrors.keySet(), AutoFollowStats.getFetchExceptionMessages(this), this.autoFollowedClusters);
    }

    private static List<String> getFetchExceptionMessages(AutoFollowStats status) {
        return status.getRecentAutoFollowErrors().values().stream().map(Tuple::v2).map(Throwable::getMessage).collect(Collectors.toList());
    }

    public String toString() {
        return "AutoFollowStats{numberOfFailedFollowIndices=" + this.numberOfFailedFollowIndices + ", numberOfFailedRemoteClusterStateRequests=" + this.numberOfFailedRemoteClusterStateRequests + ", numberOfSuccessfulFollowIndices=" + this.numberOfSuccessfulFollowIndices + ", recentAutoFollowErrors=" + this.recentAutoFollowErrors + ", autoFollowedClusters=" + this.autoFollowedClusters + '}';
    }

    static {
        AUTO_FOLLOW_EXCEPTIONS_PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_INDEX);
        AUTO_FOLLOW_EXCEPTIONS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP);
        AUTO_FOLLOW_EXCEPTIONS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), AUTO_FOLLOW_EXCEPTION);
        AUTO_FOLLOWED_CLUSTERS_PARSER.declareString(ConstructingObjectParser.constructorArg(), CLUSTER_NAME);
        AUTO_FOLLOWED_CLUSTERS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIME_SINCE_LAST_CHECK_MILLIS);
        AUTO_FOLLOWED_CLUSTERS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_SEEN_METADATA_VERSION);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_FAILED_INDICES_AUTO_FOLLOWED);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_FAILED_REMOTE_CLUSTER_STATE_REQUESTS);
        STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUMBER_OF_SUCCESSFUL_INDICES_AUTO_FOLLOWED);
        STATS_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), AUTO_FOLLOW_EXCEPTIONS_PARSER, RECENT_AUTO_FOLLOW_ERRORS);
        STATS_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), AUTO_FOLLOWED_CLUSTERS_PARSER, AUTO_FOLLOWED_CLUSTERS);
    }

    public static class AutoFollowedCluster
    implements Writeable {
        private final long timeSinceLastCheckMillis;
        private final long lastSeenMetadataVersion;

        public AutoFollowedCluster(long timeSinceLastCheckMillis, long lastSeenMetadataVersion) {
            this.timeSinceLastCheckMillis = timeSinceLastCheckMillis;
            this.lastSeenMetadataVersion = lastSeenMetadataVersion;
        }

        public AutoFollowedCluster(StreamInput in) throws IOException {
            this(in.readZLong(), in.readVLong());
        }

        public long getTimeSinceLastCheckMillis() {
            return this.timeSinceLastCheckMillis;
        }

        public long getLastSeenMetadataVersion() {
            return this.lastSeenMetadataVersion;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.timeSinceLastCheckMillis);
            out.writeVLong(this.lastSeenMetadataVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoFollowedCluster that = (AutoFollowedCluster)o;
            return this.timeSinceLastCheckMillis == that.timeSinceLastCheckMillis && this.lastSeenMetadataVersion == that.lastSeenMetadataVersion;
        }

        public int hashCode() {
            return Objects.hash(this.timeSinceLastCheckMillis, this.lastSeenMetadataVersion);
        }

        public String toString() {
            return "AutoFollowedCluster{timeSinceLastCheckMillis=" + this.timeSinceLastCheckMillis + ", lastSeenMetadataVersion=" + this.lastSeenMetadataVersion + '}';
        }
    }
}

